/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.secstation;

import java.util.ArrayList;
import me.desht.pneumaticcraft.common.block.entity.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.hacking.secstation.ISimulationController;
import me.desht.pneumaticcraft.common.inventory.SecurityStationHackingMenu;
import me.desht.pneumaticcraft.common.item.NetworkComponentItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncHackSimulationUpdate;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class SimulationController
implements ISimulationController {
    private final SecurityStationBlockEntity te;
    private final Player hacker;
    private final HackSimulation playerSimulation;
    private final HackSimulation aiSimulation;
    private final boolean justTesting;

    public SimulationController(SecurityStationBlockEntity te, Player hacker, boolean justTesting) {
        this.te = te;
        this.hacker = hacker;
        this.playerSimulation = new HackSimulation(this, te.findComponent(NetworkComponentItem.NetworkComponentType.NETWORK_IO_PORT), 0.02f, ISimulationController.HackingSide.PLAYER);
        this.aiSimulation = new HackSimulation(this, te.findComponent(NetworkComponentItem.NetworkComponentType.DIAGNOSTIC_SUBROUTINE), 0.03f, ISimulationController.HackingSide.AI);
        for (int i = 0; i < te.getPrimaryInventory().getSlots(); ++i) {
            this.playerSimulation.addNode(i, te.getPrimaryInventory().getStackInSlot(i));
            this.aiSimulation.addNode(i, te.getPrimaryInventory().getStackInSlot(i));
        }
        this.justTesting = justTesting;
    }

    public SimulationController(SecurityStationBlockEntity te, Player hacker, HackSimulation playerSimulation, HackSimulation aiSimulation, boolean justTesting) {
        this.te = te;
        this.hacker = hacker;
        this.playerSimulation = playerSimulation.setController(this);
        this.aiSimulation = aiSimulation.setController(this);
        this.justTesting = justTesting;
    }

    @Override
    public void onConnectionStarted(HackSimulation hackSimulation, int fromPos, int toPos, float initialProgress) {
    }

    @Override
    public boolean isJustTesting() {
        return this.justTesting;
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.te.m_58899_());
        this.playerSimulation.writeToNetwork(buffer);
        this.aiSimulation.writeToNetwork(buffer);
        ArrayList<Pair> nodes = new ArrayList<Pair>();
        for (int i = 0; i < this.te.getPrimaryInventory().getSlots(); ++i) {
            ItemStack stack = this.te.getPrimaryInventory().getStackInSlot(i);
            if (stack.m_41619_()) continue;
            nodes.add(Pair.of((Object)i, (Object)stack));
        }
        buffer.m_130130_(nodes.size());
        nodes.forEach(pair -> {
            buffer.m_130130_(((Integer)pair.getLeft()).intValue());
            buffer.m_130055_((ItemStack)pair.getRight());
        });
        buffer.writeBoolean(this.justTesting);
    }

    @Override
    public void onNodeHacked(HackSimulation hackSimulation, int pos) {
        if (hackSimulation.getSide() == ISimulationController.HackingSide.PLAYER && !this.aiSimulation.isAwake()) {
            this.maybeWakeAI();
        }
    }

    @Override
    public void onNodeFortified(HackSimulation hackSimulation, int pos) {
        if (hackSimulation.getSide() == ISimulationController.HackingSide.PLAYER && !this.aiSimulation.isAwake()) {
            this.maybeWakeAI();
        }
    }

    private void maybeWakeAI() {
        if (!this.te.nonNullLevel().f_46443_ && this.aiSimulation.isStarted() && this.te.nonNullLevel().f_46441_.nextInt(100) < this.te.getDetectionChance()) {
            this.aiSimulation.wakeUp();
        }
    }

    @Override
    public void tick() {
        boolean syncToClient;
        if (this.te.m_58901_() || !this.hacker.m_6084_()) {
            return;
        }
        boolean wasDone = this.isSimulationDone();
        if (!(this.hacker.f_36096_ instanceof SecurityStationHackingMenu) && !this.playerSimulation.isHackComplete()) {
            for (int slot = 0; slot < 35; ++slot) {
                if (!NetworkComponentItem.isType(this.te.getPrimaryInventory().getStackInSlot(slot), NetworkComponentItem.NetworkComponentType.NETWORK_IO_PORT)) continue;
                this.aiSimulation.getNodeAt(slot).setHackProgress(slot, 1.0f, true);
                break;
            }
        } else if (!wasDone) {
            this.playerSimulation.tick();
            this.aiSimulation.tick();
        }
        boolean bl = syncToClient = (this.te.nonNullLevel().m_46467_() & 7L) == 0L;
        if (!wasDone && this.aiSimulation.isHackComplete()) {
            syncToClient = true;
            if (this.aiSimulation.isAwake()) {
                if (this.te.nonNullLevel().f_46443_) {
                    this.hacker.m_5496_(SoundEvents.f_11900_, 1.0f, 1.0f);
                } else {
                    this.hacker.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackFailed.1", new Object[0]).m_130940_(ChatFormatting.RED), false);
                    if (!this.justTesting) {
                        this.hacker.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackFailed.2", new Object[0]).m_130940_(ChatFormatting.RED), false);
                        this.te.retaliate(this.hacker);
                    }
                }
            }
        } else if (!wasDone && this.playerSimulation.isHackComplete()) {
            syncToClient = true;
            if (this.te.nonNullLevel().f_46443_) {
                this.hacker.m_5496_(SoundEvents.f_12275_, 1.0f, 1.0f);
            } else {
                this.hacker.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackSucceeded.1", new Object[0]).m_130940_(ChatFormatting.GREEN), false);
                if (!this.justTesting) {
                    this.hacker.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackSucceeded.2", new Object[0]).m_130940_(ChatFormatting.GREEN), false);
                    this.te.addHacker(this.hacker.m_36316_());
                }
            }
        }
        if (!this.te.nonNullLevel().m_5776_() && syncToClient) {
            NetworkHandler.sendToPlayer(new PacketSyncHackSimulationUpdate(this.te), (ServerPlayer)this.hacker);
        }
    }

    @Override
    public boolean isSimulationDone() {
        return this.te.m_58901_() || !this.hacker.m_6084_() || this.aiSimulation.isHackComplete() || this.playerSimulation.isHackComplete();
    }

    @Override
    public HackSimulation getSimulation(ISimulationController.HackingSide side) {
        return side == ISimulationController.HackingSide.PLAYER ? this.playerSimulation : this.aiSimulation;
    }

    @Override
    public Player getHacker() {
        return this.hacker;
    }
}

