/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidItemWrapper
implements ICapabilityProvider {
    private ItemStack stack;
    private final String tankName;
    private final int capacity;
    private final Predicate<Fluid> fluidPredicate;
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> new Handler());

    public FluidItemWrapper(ItemStack stack, String tankName, int capacity, Predicate<Fluid> fluidPredicate) {
        this.stack = stack;
        this.tankName = tankName;
        this.capacity = capacity;
        this.fluidPredicate = fluidPredicate;
    }

    public FluidItemWrapper(ItemStack stack, String tankName, int capacity) {
        this(stack, tankName, capacity, fluid -> true);
    }

    private void serializeTank(FluidTank tank, String tagName) {
        ItemStack newStack = this.stack.m_41777_();
        CompoundTag tag = newStack.m_41698_("BlockEntityTag");
        CompoundTag subTag = tag.m_128469_("SavedTanks");
        if (!tank.getFluid().isEmpty()) {
            subTag.m_128365_(tagName, (Tag)tank.writeToNBT(new CompoundTag()));
        } else {
            subTag.m_128473_(tagName);
        }
        if (!subTag.m_128456_()) {
            tag.m_128365_("SavedTanks", (Tag)subTag);
        } else {
            tag.m_128473_("SavedTanks");
            if (tag.m_128456_()) {
                Objects.requireNonNull(newStack.m_41783_()).m_128473_("BlockEntityTag");
                if (newStack.m_41783_().m_128456_()) {
                    newStack.m_41751_(null);
                }
            }
        }
        this.stack = newStack;
    }

    private FluidTank deserializeTank(ItemStack stack, String tagName, int capacity) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null && tag.m_128441_("SavedTanks")) {
            FluidTank tank = new FluidTank(capacity);
            CompoundTag subTag = tag.m_128469_("SavedTanks");
            return tank.readFromNBT(subTag.m_128469_(tagName));
        }
        return null;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(capability, this.holder);
    }

    class Handler
    implements IFluidHandlerItem {
        private final FluidTank fluidTank;

        Handler() {
            FluidTank tank = FluidItemWrapper.this.deserializeTank(FluidItemWrapper.this.stack, FluidItemWrapper.this.tankName, FluidItemWrapper.this.capacity);
            this.fluidTank = tank == null ? new FluidTank(FluidItemWrapper.this.capacity) : tank;
        }

        @Nonnull
        public ItemStack getContainer() {
            return FluidItemWrapper.this.stack;
        }

        public int getTanks() {
            return this.fluidTank == null ? 0 : this.fluidTank.getTanks();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.fluidTank == null ? FluidStack.EMPTY : this.fluidTank.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return this.fluidTank == null ? 0 : this.fluidTank.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.fluidTank != null && FluidItemWrapper.this.fluidPredicate.test(stack.getFluid()) && this.fluidTank.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            if (this.fluidTank == null || !this.isFluidValid(0, resource)) {
                return 0;
            }
            int filled = this.fluidTank.fill(resource, doFill);
            if (filled > 0 && doFill == IFluidHandler.FluidAction.EXECUTE) {
                FluidItemWrapper.this.serializeTank(this.fluidTank, FluidItemWrapper.this.tankName);
            }
            return filled;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            if (this.fluidTank == null) {
                return FluidStack.EMPTY;
            }
            FluidStack drained = this.fluidTank.drain(resource, doDrain);
            if (!drained.isEmpty() && doDrain == IFluidHandler.FluidAction.EXECUTE) {
                FluidItemWrapper.this.serializeTank(this.fluidTank, FluidItemWrapper.this.tankName);
            }
            return drained;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            if (this.fluidTank == null) {
                return FluidStack.EMPTY;
            }
            FluidStack drained = this.fluidTank.drain(maxDrain, doDrain);
            if (!drained.isEmpty() && doDrain == IFluidHandler.FluidAction.EXECUTE) {
                FluidItemWrapper.this.serializeTank(this.fluidTank, FluidItemWrapper.this.tankName);
            }
            return drained;
        }
    }
}

