/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.recipe.ThermoPlantRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.inventory.ThermopneumaticProcessingPlantMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.util.AcceptabilityCache;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ThermopneumaticProcessingPlantBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IRedstoneControl<ThermopneumaticProcessingPlantBlockEntity>,
ISerializableTanks,
IAutoFluidEjecting,
MenuProvider,
IComparatorSupport,
IHeatExchangingTE {
    private static final int INVENTORY_SIZE = 1;
    private static final int CRAFTING_TIME = 6000;
    private static final double MAX_SPEED_UP = 2.5;
    private static final AcceptabilityCache<Item> acceptedItemCache = new AcceptabilityCache();
    private static final AcceptabilityCache<Fluid> acceptedFluidCache = new AcceptabilityCache();
    @GuiSynced
    @DescSynced
    private final ThermopneumaticFluidTankInput inputTank = new ThermopneumaticFluidTankInput(16000);
    @GuiSynced
    @DescSynced
    private final SmartSyncTank outputTank = new SmartSyncTank(this, 16000);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);
    @GuiSynced
    public final RedstoneController<ThermopneumaticProcessingPlantBlockEntity> rsController = new RedstoneController<ThermopneumaticProcessingPlantBlockEntity>(this);
    @GuiSynced
    private int craftingProgress;
    @GuiSynced
    private float requiredPressure;
    @GuiSynced
    public int minTemperature;
    @GuiSynced
    public int maxTemperature;
    @GuiSynced
    public TPProblem problem = TPProblem.OK;
    @DescSynced
    private boolean didWork;
    @GuiSynced
    private String currentRecipeIdSynced = "";
    private ThermoPlantRecipe currentRecipe;
    private boolean searchForRecipe = true;
    private final ItemStackHandler inputItemHandler = new InputItemHandler(this);
    private final ItemStackHandler outputItemHandler = new BaseItemStackHandler(this, 1);
    private final ThermopneumaticInvWrapper invWrapper = new ThermopneumaticInvWrapper((IItemHandler)this.inputItemHandler, (IItemHandler)this.outputItemHandler);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.invWrapper);
    private final ThermopneumaticFluidHandler fluidHandler = new ThermopneumaticFluidHandler();
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.fluidHandler);
    private double airUsage;

    public ThermopneumaticProcessingPlantBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.THERMOPNEUMATIC_PROCESSING_PLANT.get(), pos, state, PressureTier.TIER_ONE_HALF, 3000, 4);
        this.heatExchanger.setThermalResistance(10.0);
    }

    @Override
    public boolean canConnectPneumatic(Direction dir) {
        return this.getRotation().m_122424_() != dir && dir != Direction.UP;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.inputTank.tick();
        this.outputTank.tick();
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.didWork && this.nonNullLevel().f_46441_.nextBoolean()) {
            ClientUtils.emitParticles(this.nonNullLevel(), this.m_58899_(), (ParticleOptions)ParticleTypes.f_123762_, 0.9);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.problem = TPProblem.OK;
        ThermoPlantRecipe prevRecipe = this.currentRecipe;
        if (this.searchForRecipe) {
            this.currentRecipe = this.findApplicableRecipe();
            this.currentRecipeIdSynced = this.currentRecipe == null ? "" : this.currentRecipe.m_6423_().toString();
            this.searchForRecipe = false;
        }
        if (prevRecipe != this.currentRecipe) {
            this.nonNullLevel().m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
        }
        this.didWork = false;
        if (this.currentRecipe != null) {
            if (this.getInputTank().getFluidAmount() < this.currentRecipe.getInputFluid().getAmount()) {
                this.problem = TPProblem.NOT_ENOUGH_FLUID;
            } else if (this.heatExchanger.getTemperature() > (double)this.currentRecipe.getOperatingTemperature().getMax()) {
                this.problem = TPProblem.TOO_HOT;
            } else if (this.heatExchanger.getTemperature() < (double)this.currentRecipe.getOperatingTemperature().getMin()) {
                this.problem = TPProblem.TOO_COLD;
            } else if (this.rsController.shouldRun() && this.hasEnoughPressure()) {
                this.runOneCycle();
            }
        } else {
            this.problem = TPProblem.NO_RECIPE;
            this.craftingProgress = 0;
            this.minTemperature = 0;
            this.maxTemperature = 0;
            this.requiredPressure = 0.0f;
        }
    }

    private void runOneCycle() {
        double speedBoost;
        double d = speedBoost = this.minTemperature > 0 ? Math.min(2.5, this.heatExchanger.getTemperature() / (double)this.minTemperature) : 1.0;
        if (this.craftingProgress < 6000) {
            double progressInc = speedBoost * (double)this.currentRecipe.getRecipeSpeed() * 100.0;
            this.craftingProgress = (int)((double)this.craftingProgress + progressInc);
            double progressDivider = progressInc / 6000.0;
            this.airUsage += (double)this.currentRecipe.airUsed() * progressDivider * speedBoost * (double)this.currentRecipe.getAirUseMultiplier();
            if (this.airUsage > 1.0) {
                int i = (int)this.airUsage;
                this.addAir(-i);
                this.airUsage -= (double)i;
            }
            this.heatExchanger.addHeat(-this.currentRecipe.heatUsed(this.heatExchanger.getAmbientTemperature()) * speedBoost * 0.75 * progressDivider);
        }
        if (this.craftingProgress >= 6000) {
            int filled = this.outputTank.fill(this.currentRecipe.getOutputFluid().copy(), IFluidHandler.FluidAction.SIMULATE);
            ItemStack excess = this.outputItemHandler.insertItem(0, this.currentRecipe.getOutputItem().m_41777_(), true);
            if (filled == this.currentRecipe.getOutputFluid().getAmount() && excess.m_41619_()) {
                this.outputTank.fill(this.currentRecipe.getOutputFluid().copy(), IFluidHandler.FluidAction.EXECUTE);
                this.outputItemHandler.insertItem(0, this.currentRecipe.getOutputItem().m_41777_(), false);
                this.inputTank.drain(this.currentRecipe.getInputFluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                this.inputItemHandler.extractItem(0, this.getInputItemCount(), false);
                this.craftingProgress -= 6000;
            } else {
                this.problem = TPProblem.OUTPUT_BLOCKED;
            }
        }
        this.didWork = this.problem == TPProblem.OK;
    }

    private int getInputItemCount() {
        if (this.currentRecipe != null) {
            return this.currentRecipe.getInputItem().m_43908_().length > 0 ? this.currentRecipe.getInputItem().m_43908_()[0].m_41613_() : 1;
        }
        return 0;
    }

    private boolean hasEnoughPressure() {
        if (this.getMinWorkingPressure() == 0.0f) {
            return true;
        }
        if (this.getMinWorkingPressure() > 0.0f) {
            return this.getPressure() >= this.getMinWorkingPressure();
        }
        return this.getPressure() <= this.getMinWorkingPressure();
    }

    private ThermoPlantRecipe findApplicableRecipe() {
        for (ThermoPlantRecipe recipe : ModRecipeTypes.getRecipes(this.f_58857_, ModRecipeTypes.THERMO_PLANT)) {
            if (!recipe.matches(this.inputTank.getFluid(), this.inputItemHandler.getStackInSlot(0))) continue;
            this.requiredPressure = recipe.getRequiredPressure();
            this.minTemperature = recipe.getOperatingTemperature().getMin();
            this.maxTemperature = recipe.getOperatingTemperature().getMax();
            return recipe;
        }
        return null;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public IFluidTank getInputTank() {
        return this.inputTank;
    }

    public IFluidTank getOutputTank() {
        return this.outputTank;
    }

    public double getCraftingPercentage() {
        return (double)this.craftingProgress / 6000.0;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.inputItemHandler.serializeNBT());
        tag.m_128365_("Output", (Tag)this.outputItemHandler.serializeNBT());
        tag.m_128405_("craftingProgress", this.craftingProgress);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputItemHandler.deserializeNBT(tag.m_128469_("Items"));
        this.outputItemHandler.deserializeNBT(tag.m_128469_("Output"));
        this.craftingProgress = tag.m_128451_("craftingProgress");
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        FluidStack moved;
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (tag.equals("dump") && !(moved = shiftHeld ? this.inputTank.drain(this.inputTank.getCapacity(), IFluidHandler.FluidAction.EXECUTE) : FluidUtil.tryFluidTransfer((IFluidHandler)this.outputTank, (IFluidHandler)this.inputTank, (int)this.inputTank.getFluidAmount(), (boolean)true)).isEmpty()) {
            NetworkHandler.sendToPlayer(new PacketPlaySound(SoundEvents.f_11781_, SoundSource.BLOCKS, this.f_58858_, 1.0f, 1.0f, false), player);
        }
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inputItemHandler;
    }

    @Override
    public RedstoneController<ThermopneumaticProcessingPlantBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public float getMinWorkingPressure() {
        return this.requiredPressure;
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"InputTank", (Object)this.inputTank, (Object)"OutputTank", (Object)this.outputTank);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ThermopneumaticProcessingPlantMenu(i, playerInventory, this.m_58899_());
    }

    public IItemHandler getOutputInventory() {
        return this.outputItemHandler;
    }

    @Override
    public int getComparatorValue() {
        return this.currentRecipe != null ? 15 : 0;
    }

    public static void clearCachedItemsAndFluids() {
        acceptedItemCache.clear();
        acceptedFluidCache.clear();
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }

    @Override
    public String getCurrentRecipeIdSynced() {
        return this.currentRecipeIdSynced;
    }

    private class ThermopneumaticFluidTankInput
    extends SmartSyncTank {
        ThermopneumaticFluidTankInput(int capacity) {
            super(ThermopneumaticProcessingPlantBlockEntity.this, capacity);
        }

        @Override
        public boolean isFluidValid(FluidStack fluid) {
            return fluid.isEmpty() || acceptedFluidCache.isAcceptable(fluid.getFluid(), () -> ((PneumaticCraftRecipeType)ModRecipeTypes.THERMO_PLANT.get()).stream(ThermopneumaticProcessingPlantBlockEntity.this.f_58857_).anyMatch(r -> r.getInputFluid().testFluid(fluid.getFluid())));
        }

        @Override
        protected void onContentsChanged(Fluid prevFluid, int prevAmount) {
            super.onContentsChanged(prevFluid, prevAmount);
            FluidStack newFluid = this.getFluid();
            if (prevFluid != newFluid.getFluid() || ThermopneumaticProcessingPlantBlockEntity.this.currentRecipe == null && this.getFluidAmount() > prevAmount || ThermopneumaticProcessingPlantBlockEntity.this.currentRecipe != null && this.getFluidAmount() < prevAmount) {
                ThermopneumaticProcessingPlantBlockEntity.this.searchForRecipe = true;
            }
        }
    }

    public static enum TPProblem implements ITranslatableEnum
    {
        OK(""),
        NO_RECIPE("noRecipe"),
        NOT_ENOUGH_FLUID("notEnoughFluid"),
        TOO_HOT("tooMuchHeat"),
        TOO_COLD("notEnoughHeat"),
        OUTPUT_BLOCKED("outputBlocked");

        private final String key;

        private TPProblem(String key) {
            this.key = key;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.problems." + this.key;
        }
    }

    private class InputItemHandler
    extends BaseItemStackHandler {
        private Item prev;

        public InputItemHandler(BlockEntity te) {
            super(te, 1);
            this.prev = null;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41619_() || acceptedItemCache.isAcceptable(stack.m_41720_(), () -> ((PneumaticCraftRecipeType)ModRecipeTypes.THERMO_PLANT.get()).stream(ThermopneumaticProcessingPlantBlockEntity.this.f_58857_).anyMatch(r -> r.getInputItem().test(stack)));
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (this.getStackInSlot(0).m_41720_() != this.prev) {
                ThermopneumaticProcessingPlantBlockEntity.this.searchForRecipe = true;
            }
            this.prev = this.getStackInSlot(0).m_41720_();
        }
    }

    private class ThermopneumaticInvWrapper
    implements IItemHandler {
        private final IItemHandler input;
        private final IItemHandler output;

        ThermopneumaticInvWrapper(IItemHandler input, IItemHandler output) {
            this.input = input;
            this.output = output;
        }

        public int getSlots() {
            return 2;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? this.input.getStackInSlot(0) : this.output.getStackInSlot(0);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return slot == 0 ? ThermopneumaticProcessingPlantBlockEntity.this.inputItemHandler.insertItem(0, stack, simulate) : stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot == 1 ? ThermopneumaticProcessingPlantBlockEntity.this.outputItemHandler.extractItem(0, amount, simulate) : ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? this.input.getSlotLimit(0) : this.output.getSlotLimit(0);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 ? this.input.isItemValid(0, stack) : this.output.isItemValid(0, stack);
        }
    }

    private class ThermopneumaticFluidHandler
    implements IFluidHandler {
        final IFluidTank[] tanks;

        ThermopneumaticFluidHandler() {
            this.tanks = new IFluidTank[]{ThermopneumaticProcessingPlantBlockEntity.this.inputTank, ThermopneumaticProcessingPlantBlockEntity.this.outputTank};
        }

        public int getTanks() {
            return this.tanks.length;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.tanks[tank].getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.tanks[tank].getCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return this.tanks[tank].isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
            return ThermopneumaticProcessingPlantBlockEntity.this.inputTank.fill(resource, doFill);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
            return ThermopneumaticProcessingPlantBlockEntity.this.outputTank.getFluid().isFluidEqual(resource) ? ThermopneumaticProcessingPlantBlockEntity.this.outputTank.drain(resource.getAmount(), doDrain) : FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
            return ThermopneumaticProcessingPlantBlockEntity.this.outputTank.drain(maxDrain, doDrain);
        }
    }
}

