/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.CoordinateTrackerOptions;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderNavigator;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.ai.EntityPathNavigateDrone;
import me.desht.pneumaticcraft.common.config.ClientConfig;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModEntityTypes;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.CoordTrackerHandler;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class CoordTrackClientHandler
extends IArmorUpgradeClientHandler.AbstractHandler<CoordTrackerHandler> {
    private RenderNavigator navigator;
    private BlockPos trackedPos;
    private ResourceKey<Level> worldKey;
    public boolean isListeningToCoordTrackerSetting = false;
    public boolean pathEnabled;
    public boolean wirePath;
    public boolean xRayEnabled;
    public ClientConfig.PathUpdateSetting pathUpdateSetting = ClientConfig.PathUpdateSetting.NORMAL;
    private int pathCalculateCooldown;
    private int noPathCooldown;

    public CoordTrackClientHandler() {
        super(CommonUpgradeHandlers.coordTrackerHandler);
    }

    @Override
    public void initConfig() {
        this.pathEnabled = (Boolean)ConfigHelper.client().armor.pathEnabled.get();
        this.wirePath = (Boolean)ConfigHelper.client().armor.wirePath.get();
        this.xRayEnabled = (Boolean)ConfigHelper.client().armor.xRayEnabled.get();
        this.pathUpdateSetting = (ClientConfig.PathUpdateSetting)ConfigHelper.client().armor.pathUpdateSetting.get();
    }

    @Override
    public void saveToConfig() {
        ConfigHelper.updateCoordTracker(this.pathEnabled, this.wirePath, this.xRayEnabled, this.pathUpdateSetting);
    }

    @Override
    public void tickClient(ICommonArmorHandler armorHandler) {
        this.trackedPos = PneumaticArmorItem.getCoordTrackerPos(ClientUtils.getWornArmor(EquipmentSlot.HEAD), armorHandler.getPlayer().f_19853_);
        this.worldKey = armorHandler.getPlayer().f_19853_.m_46472_();
        if (this.trackedPos != null) {
            this.navigator = new RenderNavigator(this.trackedPos);
        }
        if (this.noPathCooldown > 0) {
            --this.noPathCooldown;
        }
        if (this.navigator != null && ((Boolean)ConfigHelper.client().armor.pathEnabled.get()).booleanValue() && this.noPathCooldown == 0 && --this.pathCalculateCooldown <= 0) {
            this.navigator.updatePath();
            if (!this.navigator.tracedToDestination()) {
                this.noPathCooldown = 100;
            }
            this.pathCalculateCooldown = ((ClientConfig.PathUpdateSetting)ConfigHelper.client().armor.pathUpdateSetting.get()).getTicks();
        }
    }

    @Override
    public void render3D(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
        if (this.trackedPos != null && ClientUtils.getClientLevel().m_46472_().m_135782_().equals((Object)this.worldKey.m_135782_()) && ((Boolean)ConfigHelper.client().armor.pathEnabled.get()).booleanValue() && this.navigator != null) {
            this.navigator.render(matrixStack, buffer, (Boolean)ConfigHelper.client().armor.wirePath.get(), (Boolean)ConfigHelper.client().armor.xRayEnabled.get(), partialTicks);
        }
    }

    @Override
    public void render2D(PoseStack matrixStack, float partialTicks, boolean armorPieceHasPressure) {
    }

    @Override
    public void reset() {
        this.trackedPos = null;
        this.navigator = null;
    }

    public EnumNavigationResult navigateToSurface(Player player) {
        BlockPos pathPos;
        Node pathPoint;
        int i;
        Level world = player.f_19853_;
        BlockPos navigatingPos = world.m_5452_(Heightmap.Types.WORLD_SURFACE, player.m_142538_());
        Mob e = PneumaticCraftUtils.createDummyEntity(player);
        Path path = e.m_21573_().m_7864_(navigatingPos, 0);
        if (path != null) {
            for (i = 0; i < path.m_77398_(); ++i) {
                pathPoint = path.m_77375_(i);
                pathPos = new BlockPos(pathPoint.f_77271_, pathPoint.f_77272_, pathPoint.f_77273_);
                if (!world.m_46861_(pathPos)) continue;
                this.trackedPos = pathPos;
                this.navigator = new RenderNavigator(pathPos);
                return EnumNavigationResult.EASY_PATH;
            }
        }
        if ((path = CoordTrackClientHandler.getDronePath(player, navigatingPos)) != null) {
            for (i = 0; i < path.m_77398_(); ++i) {
                pathPoint = path.m_77375_(i);
                pathPos = new BlockPos(pathPoint.f_77271_, pathPoint.f_77272_, pathPoint.f_77273_);
                if (!world.m_46861_(pathPos)) continue;
                this.trackedPos = pathPos;
                this.navigator = new RenderNavigator(pathPos);
                return EnumNavigationResult.DRONE_PATH;
            }
        }
        return EnumNavigationResult.NO_PATH;
    }

    public static Path getDronePath(Player player, BlockPos pos) {
        Level world = player.f_19853_;
        DroneEntity drone = new DroneEntity((EntityType<? extends DroneEntity>)((EntityType)ModEntityTypes.DRONE.get()), world);
        drone.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        return new EntityPathNavigateDrone(drone, world).m_7864_(pos, 0);
    }

    public BlockPos getTrackedPos() {
        return this.trackedPos;
    }

    @Override
    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new CoordinateTrackerOptions(screen, this);
    }

    public static enum EnumNavigationResult {
        NO_PATH,
        EASY_PATH,
        DRONE_PATH;

    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
            ItemStack helmetStack = event.getPlayer().m_6844_(EquipmentSlot.HEAD);
            if (!event.getWorld().f_46443_ || event.getPlayer().m_6844_(EquipmentSlot.HEAD).m_41720_() != ModItems.PNEUMATIC_HELMET.get()) {
                return;
            }
            CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
            if (commonArmorHandler.getUpgradeCount(EquipmentSlot.HEAD, (PNCUpgrade)((Object)ModUpgrades.COORDINATE_TRACKER.get())) == 0) {
                return;
            }
            CoordTrackClientHandler handler = ArmorUpgradeClientRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.coordTrackerHandler, CoordTrackClientHandler.class);
            if (handler.isListeningToCoordTrackerSetting) {
                handler.isListeningToCoordTrackerSetting = false;
                if (event.getFace() != null) {
                    handler.reset();
                    GlobalPos gPos = GlobalPosHelper.makeGlobalPos(event.getWorld(), event.getPos().m_142300_(event.getFace()));
                    PneumaticArmorItem.setCoordTrackerPos(helmetStack, gPos);
                    CompoundTag tag = new CompoundTag();
                    tag.m_128365_("CoordTracker", (Tag)GlobalPosHelper.toNBT(gPos));
                    NetworkHandler.sendToServer(new PacketUpdateArmorExtraData(EquipmentSlot.HEAD, tag, handler.getID()));
                    HUDHandler.getInstance().addMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.coordinateTracker.selectedTarget", PneumaticCraftUtils.posToString(gPos.m_122646_())), Collections.emptyList(), 60, -2147440128);
                }
            }
        }
    }
}

