/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.common.block.entity.ElevatorBaseBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class ElevatorBaseRenderer
extends AbstractBlockEntityModelRenderer<ElevatorBaseBlockEntity> {
    private static final float FACTOR = 0.5625f;
    private static final float[] SHADE = new float[]{1.0f, 0.85f, 0.7f, 0.55f};
    private final ModelPart pole1;
    private final ModelPart pole2;
    private final ModelPart pole3;
    private final ModelPart pole4;
    private final ModelPart floor;
    private static final String POLE1 = "pole1";
    private static final String POLE2 = "pole2";
    private static final String POLE3 = "pole3";
    private static final String POLE4 = "pole4";
    private static final String FLOOR = "floor";

    public ElevatorBaseRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.m_173582_(PNCModelLayers.ELEVATOR_BASE);
        this.pole1 = root.m_171324_(POLE1);
        this.pole2 = root.m_171324_(POLE2);
        this.pole3 = root.m_171324_(POLE3);
        this.pole4 = root.m_171324_(POLE4);
        this.floor = root.m_171324_(FLOOR);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(POLE1, CubeListBuilder.m_171558_().m_171514_(28, 41).m_171517_("pole1_0", -19.5f, 0.0f, -1.5f, 5.0f, 14.0f, 5.0f), PartPose.m_171419_((float)17.0f, (float)9.0f, (float)-1.0f));
        partdefinition.m_171599_(POLE2, CubeListBuilder.m_171558_().m_171514_(32, 19).m_171517_("pole2_0", -15.0f, 0.0f, -1.0f, 6.0f, 14.0f, 6.0f), PartPose.m_171419_((float)12.0f, (float)9.0f, (float)-2.0f));
        partdefinition.m_171599_(POLE3, CubeListBuilder.m_171558_().m_171514_(0, 39).m_171517_("pole3_0", -8.5f, 0.0f, 8.5f, 7.0f, 14.0f, 7.0f), PartPose.m_171419_((float)5.0f, (float)9.0f, (float)-12.0f));
        partdefinition.m_171599_(POLE4, CubeListBuilder.m_171558_().m_171514_(0, 17).m_171517_("pole4_0", 0.0f, 0.0f, 0.0f, 8.0f, 14.0f, 8.0f), PartPose.m_171419_((float)-4.0f, (float)9.0f, (float)-4.0f));
        partdefinition.m_171599_(FLOOR, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171517_("floor_0", 0.0f, 0.0f, 0.0f, 16.0f, 1.0f, 16.0f), PartPose.m_171419_((float)-8.0f, (float)8.0f, (float)-8.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void renderModel(ElevatorBaseBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (te.extension == 0.0) {
            return;
        }
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)Textures.MODEL_ELEVATOR));
        double extension = Mth.m_14139_((double)partialTicks, (double)te.oldExtension, (double)te.extension);
        this.renderPole(matrixStackIn, builder, te.lightAbove, combinedOverlayIn, this.pole4, 0, extension);
        this.renderPole(matrixStackIn, builder, te.lightAbove, combinedOverlayIn, this.pole3, 1, extension);
        this.renderPole(matrixStackIn, builder, te.lightAbove, combinedOverlayIn, this.pole2, 2, extension);
        this.renderPole(matrixStackIn, builder, te.lightAbove, combinedOverlayIn, this.pole1, 3, extension);
        this.floor.m_104301_(matrixStackIn, builder, te.lightAbove, combinedOverlayIn);
    }

    @Override
    protected void renderExtras(ElevatorBaseBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.fakeFloorTextureUV != null && te.fakeFloorTextureUV.length == 4) {
            matrixStack.m_85836_();
            double extension = Mth.m_14139_((double)partialTicks, (double)te.oldExtension, (double)te.extension);
            matrixStack.m_85837_(0.0, extension + (double)1.0005f, 0.0);
            VertexConsumer builder = iRenderTypeBuffer.m_6299_(ModRenderTypes.getTextureRender(TextureAtlas.f_118259_));
            float uMin = te.fakeFloorTextureUV[0];
            float vMin = te.fakeFloorTextureUV[1];
            float uMax = te.fakeFloorTextureUV[2];
            float vMax = te.fakeFloorTextureUV[3];
            Matrix4f posMat = matrixStack.m_85850_().m_85861_();
            builder.m_85982_(posMat, 0.0f, 0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMin, vMax).m_85969_(te.lightAbove).m_5752_();
            builder.m_85982_(posMat, 1.0f, 0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, vMax).m_85969_(te.lightAbove).m_5752_();
            builder.m_85982_(posMat, 1.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMax, vMin).m_85969_(te.lightAbove).m_5752_();
            builder.m_85982_(posMat, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uMin, vMin).m_85969_(te.lightAbove).m_5752_();
            matrixStack.m_85849_();
        }
    }

    private void renderPole(PoseStack matrixStackIn, VertexConsumer builder, int combinedLightIn, int combinedOverlayIn, ModelPart pole, int idx, double extension) {
        matrixStackIn.m_85837_(0.0, -extension / 4.0, 0.0);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, 0.5625, 0.0);
        matrixStackIn.m_85841_(1.0f, (float)(extension * 16.0 / 14.0 / 4.0), 1.0f);
        matrixStackIn.m_85837_(0.0, -0.5625, 0.0);
        pole.m_104306_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn, SHADE[idx], SHADE[idx], SHADE[idx], 1.0f);
        matrixStackIn.m_85849_();
    }

    public boolean shouldRenderOffScreen(ElevatorBaseBlockEntity te) {
        return true;
    }

    public boolean shouldRender(ElevatorBaseBlockEntity pBlockEntity, Vec3 pCameraPos) {
        return Vec3.m_82512_((Vec3i)pBlockEntity.m_58899_()).m_82542_(1.0, 0.0, 1.0).m_82509_((Position)pCameraPos.m_82542_(1.0, 0.0, 1.0), (double)this.m_142163_());
    }
}

