/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model.custom;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class CamouflageModel
implements IDynamicBakedModel {
    private final BakedModel originalModel;

    private CamouflageModel(BakedModel originalModel) {
        this.originalModel = originalModel;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData modelData) {
        if (state == null || !(state.m_60734_() instanceof AbstractCamouflageBlock)) {
            return this.originalModel.getQuads(state, side, rand, modelData);
        }
        BlockState camoState = (BlockState)modelData.getData(AbstractCamouflageBlock.CAMO_STATE);
        RenderType layer = MinecraftForgeClient.getRenderType();
        if (layer == null) {
            layer = RenderType.m_110451_();
        }
        if (camoState == null && layer == RenderType.m_110451_()) {
            return this.originalModel.getQuads(state, side, rand, modelData);
        }
        if (camoState != null && ItemBlockRenderTypes.canRenderInLayer((BlockState)camoState, (RenderType)layer)) {
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(camoState);
            return model.getQuads(camoState, side, rand, modelData);
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return this.originalModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.originalModel.m_7539_();
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return this.originalModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.originalModel.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.originalModel.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.originalModel.m_7343_();
    }

    private static class Geometry
    implements IModelGeometry<Geometry> {
        private final BlockModel baseModel;

        Geometry(BlockModel baseModel) {
            this.baseModel = baseModel;
        }

        public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            return new CamouflageModel(this.baseModel.m_111449_(bakery, this.baseModel, spriteGetter, modelTransform, modelLocation, true));
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.baseModel.m_5500_(modelGetter, missingTextureErrors);
        }
    }

    public static enum Loader implements IModelLoader<Geometry>
    {
        INSTANCE;


        public void m_6213_(ResourceManager resourceManager) {
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"base_model"), BlockModel.class);
            return new Geometry(baseModel);
        }
    }
}

