/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor.options;

import java.util.Optional;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.ICheckboxWidget;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IKeybindingButton;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.AbstractSliderOptions;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.PneumaticHelmetRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.JetBootsClientHandler;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.JetBootsHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;

public class JetBootsOptions
extends AbstractSliderOptions<JetBootsClientHandler> {
    private ICheckboxWidget checkBoxBuilderMode;
    private ICheckboxWidget checkBoxStabilizers;
    private IKeybindingButton changeKeybindingButton;

    public JetBootsOptions(IGuiScreen screen, JetBootsClientHandler upgradeHandler) {
        super(screen, upgradeHandler);
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        super.populateGui(gui);
        IPneumaticHelmetRegistry registry = PneumaticRegistry.getInstance().getHelmetRegistry();
        ResourceLocation ownerID = ((JetBootsClientHandler)this.getClientUpgradeHandler()).getID();
        this.checkBoxBuilderMode = registry.makeKeybindingCheckBox(JetBootsClientHandler.MODULE_BUILDER_MODE, 5, 45, -1, b -> this.setFlag("JetBootsBuilderMode", 3, (ICheckboxWidget)b)).withOwnerUpgradeID(ownerID);
        gui.addWidget(this.checkBoxBuilderMode.asWidget());
        this.checkBoxStabilizers = registry.makeKeybindingCheckBox(JetBootsClientHandler.MODULE_FLIGHT_STABILIZERS, 5, 65, -1, b -> this.setFlag("JetBootsStabilizers", 4, (ICheckboxWidget)b)).withOwnerUpgradeID(ownerID);
        gui.addWidget(this.checkBoxStabilizers.asWidget());
        ICheckboxWidget hoverControl = registry.makeKeybindingCheckBox(JetBootsClientHandler.MODULE_SMART_HOVER, 5, 85, -1, b -> this.setFlag("SmartHover", 1, (ICheckboxWidget)b)).withOwnerUpgradeID(ownerID);
        gui.addWidget(hoverControl.asWidget());
        this.changeKeybindingButton = registry.makeKeybindingButton(135, KeyHandler.getInstance().keybindJetBoots);
        gui.addWidget(this.changeKeybindingButton.asWidget());
        gui.addWidget(PneumaticHelmetRegistry.getInstance().makeStatMoveButton(30, 157, (IArmorUpgradeClientHandler<?>)this.getClientUpgradeHandler()));
    }

    @Override
    protected PointXY getSliderPos() {
        return new PointXY(30, 105);
    }

    private void setFlag(String flagName, int minTier, ICheckboxWidget cb) {
        CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
        if (commonArmorHandler.getUpgradeCount(EquipmentSlot.FEET, (PNCUpgrade)((Object)ModUpgrades.JET_BOOTS.get())) >= minTier) {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_(flagName, cb.isChecked());
            JetBootsHandler upgradeHandler = (JetBootsHandler)((JetBootsClientHandler)this.getClientUpgradeHandler()).getCommonHandler();
            NetworkHandler.sendToServer(new PacketUpdateArmorExtraData(EquipmentSlot.FEET, tag, upgradeHandler.getID()));
            upgradeHandler.onDataFieldUpdated(CommonArmorHandler.getHandlerForPlayer(), flagName, tag.m_128423_(flagName));
            ResourceLocation ownerId = upgradeHandler.getID();
            HUDHandler.getInstance().addFeatureToggleMessage(IArmorUpgradeHandler.getStringKey(ownerId), IArmorUpgradeHandler.getStringKey(cb.getUpgradeId()), cb.isChecked());
        }
    }

    @Override
    public void tick() {
        super.tick();
        int nUpgrades = CommonArmorHandler.getHandlerForPlayer().getUpgradeCount(EquipmentSlot.FEET, (PNCUpgrade)((Object)ModUpgrades.JET_BOOTS.get()));
        this.checkBoxBuilderMode.asWidget().f_93623_ = nUpgrades >= 3;
        this.checkBoxStabilizers.asWidget().f_93623_ = nUpgrades >= 4;
    }

    @Override
    protected String getTagName() {
        return "JetBootsPower";
    }

    @Override
    protected Component getPrefix() {
        return new TextComponent("Power: ");
    }

    @Override
    protected Component getSuffix() {
        return new TextComponent("%");
    }

    @Override
    public Optional<IKeybindingButton> getKeybindingButton() {
        return Optional.of(this.changeKeybindingButton);
    }
}

