/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.HackSimulationRenderer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.hacking.secstation.ISimulationController;
import me.desht.pneumaticcraft.common.inventory.SecurityStationHackingMenu;
import me.desht.pneumaticcraft.common.item.NetworkComponentItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SecurityStationHackingScreen
extends AbstractPneumaticCraftContainerScreen<SecurityStationHackingMenu, SecurityStationBlockEntity> {
    private WidgetAnimatedStat statusStat;
    private HackSimulationRenderer hackRenderer;
    private HackSimulation bgSimulation;
    private int stopWorms = 0;
    private int nukeViruses = 0;
    private final ItemStack stopWorm = new ItemStack((ItemLike)ModItems.STOP_WORM.get());
    private final ItemStack nukeVirus = new ItemStack((ItemLike)ModItems.NUKE_VIRUS.get());
    private WidgetButtonExtended nukeVirusButton;
    private WidgetButtonExtended stopWormButton;

    public SecurityStationHackingScreen(SecurityStationHackingMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.f_97727_ = 238;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.status", new Object[0]), new ItemStack((ItemLike)ModBlocks.SECURITY_STATION.get()), -22016, false);
        this.addInfoTab(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.info.security_station.hacking", new Object[0]));
        this.addAnimatedStat((Component)PneumaticCraftUtils.xlate(((Item)ModItems.NUKE_VIRUS.get()).m_5524_(), new Object[0]), new ItemStack((ItemLike)ModItems.NUKE_VIRUS.get()), -15152664, false).setText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.security_station.nukeVirus", new Object[0]));
        this.addAnimatedStat((Component)PneumaticCraftUtils.xlate(((Item)ModItems.STOP_WORM.get()).m_5524_(), new Object[0]), new ItemStack((ItemLike)ModItems.STOP_WORM.get()), -4115918, false).setText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.security_station.stopWorm", new Object[0]));
        this.nukeVirusButton = new WidgetButtonExtended(this.f_97735_ + 152, this.f_97736_ + 95, 18, 18, "").setRenderStacks(this.nukeVirus);
        this.m_142416_((GuiEventListener)this.nukeVirusButton);
        this.stopWormButton = new WidgetButtonExtended(this.f_97735_ + 152, this.f_97736_ + 143, 18, 18, "", b -> {
            if (!((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI).isStopWormed()) {
                PneumaticCraftUtils.consumeInventoryItem(ClientUtils.getClientPlayer().m_150109_(), (Item)ModItems.STOP_WORM.get());
                ClientUtils.getClientPlayer().m_5496_(SoundEvents.f_12389_, 1.0f, 1.0f);
            }
        });
        ((WidgetButtonExtended)this.m_142416_((GuiEventListener)this.stopWormButton)).withTag("stop_worm").setRenderStacks(this.stopWorm);
        this.initConnectionRendering();
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    private void initConnectionRendering() {
        this.hackRenderer = new HackSimulationRenderer(this.f_97735_ + 16, this.f_97736_ + 30, 31);
        this.bgSimulation = HackSimulation.dummySimulation();
        this.bgSimulation.wakeUp();
        for (int i = 0; i < ((SecurityStationBlockEntity)this.te).getPrimaryInventory().getSlots(); ++i) {
            this.bgSimulation.addNode(i, ((SecurityStationBlockEntity)this.te).getPrimaryInventory().getStackInSlot(i));
        }
    }

    public static void addExtraHackInfoStatic(List<Component> curInfo) {
        if (Minecraft.m_91087_().f_91080_ instanceof SecurityStationHackingScreen) {
            ((SecurityStationHackingScreen)Minecraft.m_91087_().f_91080_).addExtraHackInfo(curInfo);
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_HACKING;
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    @Override
    protected boolean shouldAddUpgradeTab() {
        return false;
    }

    @Override
    protected boolean shouldAddRedstoneTab() {
        return false;
    }

    @Override
    protected PointXY getInvNameOffset() {
        return null;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        super.m_7027_(matrixStack, x, y);
        if (((SecurityStationBlockEntity)this.te).getSimulationController() != null) {
            HackSimulation aiSim = ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI);
            HackSimulation playerSim = ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
            if (aiSim.isAwake()) {
                SecurityStationHackingScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.aiTracing", new Object[0]).m_130940_(ChatFormatting.RED), (int)(this.f_97726_ / 2), (int)7, (int)0xFFFFFF);
            } else {
                SecurityStationHackingScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.detectionChance", ((SecurityStationBlockEntity)this.te).getDetectionChance()).m_130940_(ChatFormatting.GOLD), (int)(this.f_97726_ / 2), (int)7, (int)0xFFFFFF);
            }
            if (aiSim.isHackComplete()) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackFailed.1", new Object[0]).m_130940_(ChatFormatting.RED));
                if (!((SecurityStationBlockEntity)this.te).getSimulationController().isJustTesting()) {
                    builder.add((Object)TextComponent.f_131282_);
                    builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackFailed.2", new Object[0]).m_130940_(ChatFormatting.RED));
                }
                GuiUtils.showPopupHelpScreen(matrixStack, (Screen)this, this.f_96547_, (List<Component>)builder.build());
            } else if (playerSim.isHackComplete()) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackSucceeded.1", new Object[0]).m_130940_(ChatFormatting.GREEN));
                if (!((SecurityStationBlockEntity)this.te).getSimulationController().isJustTesting()) {
                    builder.add((Object)TextComponent.f_131282_);
                    builder.add((Object)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackSucceeded.2", new Object[0]).m_130940_(ChatFormatting.GREEN));
                }
                GuiUtils.showPopupHelpScreen(matrixStack, (Screen)this, this.f_96547_, (List<Component>)builder.build());
            }
        }
        this.renderConsumables(matrixStack);
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        super.m_7286_(matrixStack, partialTicks, x, y);
        this.hackRenderer.render(matrixStack, this.bgSimulation, -14540033);
        if (((SecurityStationBlockEntity)this.te).getSimulationController() != null) {
            HackSimulation aiSim = ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI);
            if (!aiSim.isStopWormed() || (((SecurityStationBlockEntity)this.te).m_58904_().m_46467_() & 0xFL) < 8L) {
                this.hackRenderer.render(matrixStack, ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI), -65536);
            }
            this.hackRenderer.render(matrixStack, ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER), -16711936);
        }
    }

    private void renderConsumables(PoseStack matrixStack) {
        this.f_96547_.m_92883_(matrixStack, PneumaticCraftUtils.convertAmountToString(this.nukeViruses), 158.0f, 112.0f, this.nukeViruses == 0 ? -40864 : -1);
        this.f_96547_.m_92883_(matrixStack, PneumaticCraftUtils.convertAmountToString(this.stopWorms), 158.0f, 160.0f, this.stopWorms == 0 ? -40864 : -1);
    }

    @Override
    public void m_181908_() {
        HackSimulation aiSim;
        super.m_181908_();
        this.stopWorms = 0;
        this.nukeViruses = 0;
        for (ItemStack stack : ClientUtils.getClientPlayer().m_150109_().f_35974_) {
            if (stack.m_41720_() == ModItems.STOP_WORM.get()) {
                this.stopWorms += stack.m_41613_();
            }
            if (stack.m_41720_() != ModItems.NUKE_VIRUS.get()) continue;
            this.nukeViruses += stack.m_41613_();
        }
        this.bgSimulation.tick();
        this.statusStat.setText(this.getStatusText());
        HackSimulation playerSim = ((SecurityStationBlockEntity)this.te).getSimulationController() == null ? null : ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
        HackSimulation hackSimulation = aiSim = ((SecurityStationBlockEntity)this.te).getSimulationController() == null ? null : ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.AI);
        if (aiSim != null && aiSim.isAwake()) {
            this.stopWormButton.f_93623_ = this.stopWorms > 0;
            this.stopWormButton.setTooltipText((Component)(this.stopWorms > 0 ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.stopWorm", new Object[0]) : PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.stopWorm.none", new Object[0]).m_130940_(ChatFormatting.GOLD)));
        } else {
            this.stopWormButton.f_93623_ = false;
            this.stopWormButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.stopWorm.notTracing", new Object[0]).m_130940_(ChatFormatting.GOLD));
        }
        if (playerSim != null) {
            boolean bl = this.nukeVirusButton.f_93623_ = this.hasNukeViruses() && playerSim.isNukeVirusReady();
            if (playerSim.isNukeVirusReady()) {
                this.nukeVirusButton.setTooltipText((Component)(this.hasNukeViruses() ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.nukeVirus", new Object[0]) : PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.nukeVirus.none", new Object[0]).m_130940_(ChatFormatting.GOLD)));
            } else {
                this.nukeVirusButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.securityStation.nukeVirus.coolDown", new Object[0]).m_130940_(ChatFormatting.GOLD));
            }
        }
    }

    private List<Component> getStatusText() {
        ArrayList<Component> text = new ArrayList<Component>();
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.securityLevel", new Object[0]).m_130940_(ChatFormatting.WHITE));
        text.add((Component)new TextComponent("L" + ((SecurityStationBlockEntity)this.te).getSecurityLevel()).m_130940_(ChatFormatting.BLACK));
        text.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.status.securityStation.securityRange", new Object[0]).m_130940_(ChatFormatting.WHITE));
        text.add((Component)new TextComponent(((SecurityStationBlockEntity)this.te).getRange() * 2 + 1 + "m\u00b2").m_130940_(ChatFormatting.BLACK));
        return text;
    }

    protected void m_6597_(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotIn != null && slotIn.m_6657_() && ((SecurityStationBlockEntity)this.te).getSimulationController() != null) {
            switch (mouseButton) {
                case 0: {
                    this.tryHackSlot(slotId);
                    break;
                }
                case 1: {
                    this.tryFortifySlot(slotId);
                    break;
                }
                case 2: {
                    this.tryNukeVirus(slotId);
                }
            }
        } else {
            super.m_6597_(slotIn, slotId, mouseButton, type);
        }
    }

    private void tryFortifySlot(int slotId) {
        HackSimulation playerSim = ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
        HackSimulation.Node node = playerSim.getNodeAt(slotId);
        if (node.isHacked() && !node.isFortified() && node.getFortification() == 0) {
            playerSim.fortify(slotId);
            NetworkHandler.sendToServer(new PacketGuiButton("fortify:" + slotId));
        }
    }

    private void tryHackSlot(int slotId) {
        HackSimulation playerSim = ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
        HackSimulation.Node node = playerSim.getNodeAt(slotId);
        if (!node.isHacked() && playerSim.getHackedNeighbour(slotId) >= 0) {
            playerSim.startHack(slotId);
            NetworkHandler.sendToServer(new PacketGuiButton("hack:" + slotId));
        }
    }

    private void tryNukeVirus(int slotId) {
        HackSimulation playerSim;
        HackSimulation.Node node;
        if (this.hasNukeViruses() && ((SecurityStationBlockEntity)this.te).getSimulationController() != null && !(node = (playerSim = ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER)).getNodeAt(slotId)).isHacked() && playerSim.getHackedNeighbour(slotId) >= 0 && playerSim.initiateNukeVirus(slotId)) {
            NetworkHandler.sendToServer(new PacketGuiButton("nuke:" + slotId));
            PneumaticCraftUtils.consumeInventoryItem(ClientUtils.getClientPlayer().m_150109_(), (Item)ModItems.NUKE_VIRUS.get());
        }
    }

    public void addExtraHackInfo(List<Component> toolTip) {
        HackSimulation playerSim;
        HackSimulation.Node node;
        if (this.f_97734_ != null && ((SecurityStationBlockEntity)this.te).getSimulationController() != null && (node = (playerSim = ((SecurityStationBlockEntity)this.te).getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER)).getNodeAt(this.f_97734_.f_40219_)) != null) {
            if (node.isHacked()) {
                if (node.getFortification() == 0) {
                    toolTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.rightClickFortify", new Object[0]).m_130940_(ChatFormatting.DARK_AQUA));
                } else if (node.getFortificationProgress() < 1.0f) {
                    toolTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.fortifyProgress", (int)(node.getFortificationProgress() * 100.0f)).m_130940_(ChatFormatting.DARK_AQUA));
                } else {
                    toolTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.fortified", new Object[0]).m_130940_(ChatFormatting.AQUA));
                }
            } else if (playerSim.getHackedNeighbour(this.f_97734_.f_40219_) >= 0) {
                if (node.getHackProgress() == 0.0f) {
                    toolTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.leftClickHack", new Object[0]).m_130940_(ChatFormatting.GREEN));
                } else {
                    toolTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.hackProgress", (int)(node.getHackProgress() * 100.0f)).m_130940_(ChatFormatting.GREEN));
                }
                if (this.nukeViruses > 0 && playerSim.isNukeVirusReady() && node.getType() == NetworkComponentItem.NetworkComponentType.NETWORK_NODE) {
                    toolTip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.hacking.middleClickNuke", new Object[0]).m_130940_(ChatFormatting.YELLOW));
                }
            }
        }
    }

    boolean hasNukeViruses() {
        return this.nukeViruses > 0;
    }
}

