/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.config.Theme;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.hud.Line;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.screen.ThemeEditorScreen;
import mcp.mobius.waila.gui.widget.CategoryEntry;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.BooleanValue;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.gui.widget.value.CycleValue;
import mcp.mobius.waila.gui.widget.value.EnumValue;
import mcp.mobius.waila.gui.widget.value.InputValue;
import mcp.mobius.waila.mixin.KeyMappingAccess;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WailaConfigScreen
extends ConfigScreen {
    private static final Component PREVIEW_PROMPT = new TranslatableComponent("config.waila.preview_prompt");
    private final WailaConfig defaultConfig = new WailaConfig();
    private final TooltipRenderer.State previewState = new PreviewTooltipRendererState();
    @Nullable
    private Theme theme;
    private boolean f1held = false;
    private ConfigValue<String> modNameFormatVal;
    private ConfigValue<String> blockNameFormatVal;
    private ConfigValue<Integer> xPosValue;
    private ConfigValue<IWailaConfig.Overlay.Position.Align.X> xAnchorValue;
    private ConfigValue<IWailaConfig.Overlay.Position.Align.Y> yAnchorValue;
    private ConfigValue<IWailaConfig.Overlay.Position.Align.X> xAlignValue;
    private ConfigValue<IWailaConfig.Overlay.Position.Align.Y> yAlignValue;
    private ConfigValue<Integer> yPosValue;
    private ConfigValue<Float> scaleValue;
    private ConfigValue<Integer> alphaVal;
    private ThemeValue themeIdVal;
    private KeyBindValue selectedKeyBind;

    public WailaConfigScreen(Screen parent) {
        super(parent, (Component)new TranslatableComponent("gui.waila.configuration", new Object[]{"WTHIT"}), Waila.CONFIG::save, Waila.CONFIG::invalidate);
    }

    private static WailaConfig get() {
        return Waila.CONFIG.get();
    }

    public void buildPreview(TooltipRenderer.State state) {
        TooltipRenderer.beginBuild(state);
        TooltipRenderer.setIcon(new ItemComponent((ItemLike)Blocks.f_50440_));
        TooltipRenderer.add(new Line(null).with((Component)new TextComponent(DisplayUtil.tryFormat(this.blockNameFormatVal.getValue(), Blocks.f_50440_.m_49954_().getString()))));
        TooltipRenderer.add(new Line(null).with((Component)new TextComponent("never gonna give you up").m_130940_(ChatFormatting.OBFUSCATED)));
        TooltipRenderer.add(new Line(null).with((Component)new TextComponent(DisplayUtil.tryFormat(this.modNameFormatVal.getValue(), IModInfo.get(Blocks.f_50440_).getName()))));
        TooltipRenderer.endBuild();
    }

    public void addTheme(Theme theme) {
        String id = theme.getId().toString();
        this.themeIdVal.addValue(id);
        this.themeIdVal.setValue(id);
        WailaConfigScreen.get().getOverlay().getColor().themes().put(theme.getId(), theme);
        this.theme = theme;
    }

    public void removeTheme(ResourceLocation id) {
        this.themeIdVal.removeValue(id.toString());
        WailaConfigScreen.get().getOverlay().getColor().themes().remove(id);
        this.theme = null;
    }

    private Theme getTheme() {
        if (this.theme == null) {
            this.theme = WailaConfigScreen.get().getOverlay().getColor().themes().get(new ResourceLocation((String)this.themeIdVal.getValue()));
        }
        return this.theme;
    }

    @Override
    public void m_6305_(@NotNull PoseStack matrices, int mouseX, int mouseY, float partialTicks) {
        if (InputConstants.m_84830_((long)this.f_96541_.m_91268_().m_85439_(), (int)290)) {
            if (!this.f1held) {
                this.f1held = true;
                this.buildPreview(this.previewState);
            }
            this.m_7333_(matrices);
            TooltipRenderer.render(matrices, partialTicks);
        } else {
            TooltipRenderer.resetState();
            this.f1held = false;
            this.theme = null;
            super.m_6305_(matrices, mouseX, mouseY, partialTicks);
            WailaConfigScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)PREVIEW_PROMPT, (int)(this.f_96543_ / 2), (int)22, (int)0xAAAAAA);
        }
    }

    @Override
    public ConfigListWidget getOptions() {
        ConfigListWidget options = new ConfigListWidget(this, this.f_96541_, this.f_96543_, this.f_96544_, 42, this.f_96544_ - 32, 26, Waila.CONFIG::save);
        options.with(new CategoryEntry("config.waila.general")).with(new BooleanValue("config.waila.display_tooltip", WailaConfigScreen.get().getGeneral().isDisplayTooltip(), this.defaultConfig.getGeneral().isDisplayTooltip(), val -> WailaConfigScreen.get().getGeneral().setDisplayTooltip((boolean)val))).with(new BooleanValue("config.waila.sneaky_details", WailaConfigScreen.get().getGeneral().isShiftForDetails(), this.defaultConfig.getGeneral().isShiftForDetails(), val -> WailaConfigScreen.get().getGeneral().setShiftForDetails((boolean)val))).with(new BooleanValue("config.waila.hide_sneak_text", WailaConfigScreen.get().getGeneral().isHideShiftText(), this.defaultConfig.getGeneral().isHideShiftText(), val -> WailaConfigScreen.get().getGeneral().setHideShiftText((boolean)val))).with(new EnumValue("config.waila.display_mode", (Enum[])IWailaConfig.General.DisplayMode.values(), (Enum)WailaConfigScreen.get().getGeneral().getDisplayMode(), (Enum)this.defaultConfig.getGeneral().getDisplayMode(), val -> WailaConfigScreen.get().getGeneral().setDisplayMode((IWailaConfig.General.DisplayMode)((Object)val)))).with(new BooleanValue("config.waila.hide_from_players", WailaConfigScreen.get().getGeneral().isHideFromPlayerList(), this.defaultConfig.getGeneral().isHideFromPlayerList(), val -> WailaConfigScreen.get().getGeneral().setHideFromPlayerList((boolean)val))).with(new BooleanValue("config.waila.hide_from_debug", WailaConfigScreen.get().getGeneral().isHideFromDebug(), this.defaultConfig.getGeneral().isHideFromDebug(), val -> WailaConfigScreen.get().getGeneral().setHideFromDebug((boolean)val))).with(new BooleanValue("config.waila.tts", WailaConfigScreen.get().getGeneral().isEnableTextToSpeech(), this.defaultConfig.getGeneral().isEnableTextToSpeech(), val -> WailaConfigScreen.get().getGeneral().setEnableTextToSpeech((boolean)val))).with(new InputValue<Integer>("config.waila.rate_limit", WailaConfigScreen.get().getGeneral().getRateLimit(), this.defaultConfig.getGeneral().getRateLimit(), val -> WailaConfigScreen.get().getGeneral().setRateLimit(Math.max(val, 250)), InputValue.POSITIVE_INTEGER));
        this.xAnchorValue = new EnumValue("config.waila.overlay_anchor_x", (Enum[])IWailaConfig.Overlay.Position.Align.X.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAnchor().getX(), (Enum)this.defaultConfig.getOverlay().getPosition().getAnchor().getX(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAnchor().setX((IWailaConfig.Overlay.Position.Align.X)((Object)val)));
        this.yAnchorValue = new EnumValue("config.waila.overlay_anchor_y", (Enum[])IWailaConfig.Overlay.Position.Align.Y.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAnchor().getY(), (Enum)this.defaultConfig.getOverlay().getPosition().getAnchor().getY(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAnchor().setY((IWailaConfig.Overlay.Position.Align.Y)((Object)val)));
        this.xAlignValue = new EnumValue("config.waila.overlay_align_x", (Enum[])IWailaConfig.Overlay.Position.Align.X.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAlign().getX(), (Enum)this.defaultConfig.getOverlay().getPosition().getAlign().getX(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAlign().setX((IWailaConfig.Overlay.Position.Align.X)((Object)val)));
        this.yAlignValue = new EnumValue("config.waila.overlay_align_y", (Enum[])IWailaConfig.Overlay.Position.Align.Y.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAlign().getY(), (Enum)this.defaultConfig.getOverlay().getPosition().getAlign().getY(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAlign().setY((IWailaConfig.Overlay.Position.Align.Y)((Object)val)));
        this.xPosValue = new InputValue<Integer>("config.waila.overlay_pos_x", WailaConfigScreen.get().getOverlay().getPosition().getX(), this.defaultConfig.getOverlay().getPosition().getX(), val -> WailaConfigScreen.get().getOverlay().getPosition().setX((int)val), InputValue.INTEGER);
        this.yPosValue = new InputValue<Integer>("config.waila.overlay_pos_y", WailaConfigScreen.get().getOverlay().getPosition().getY(), this.defaultConfig.getOverlay().getPosition().getY(), val -> WailaConfigScreen.get().getOverlay().getPosition().setY((int)val), InputValue.INTEGER);
        this.scaleValue = new InputValue<Float>("config.waila.overlay_scale", Float.valueOf(WailaConfigScreen.get().getOverlay().getScale()), Float.valueOf(this.defaultConfig.getOverlay().getScale()), val -> WailaConfigScreen.get().getOverlay().setScale(Math.max(val.floatValue(), 0.0f)), InputValue.POSITIVE_DECIMAL);
        this.alphaVal = new InputValue<Integer>("config.waila.overlay_alpha", WailaConfigScreen.get().getOverlay().getColor().rawAlpha(), this.defaultConfig.getOverlay().getColor().rawAlpha(), val -> WailaConfigScreen.get().getOverlay().getColor().setAlpha(Math.min(100, Math.max(0, val))), InputValue.POSITIVE_INTEGER);
        this.themeIdVal = new ThemeValue();
        options.with(new CategoryEntry("config.waila.overlay")).with(this.xAnchorValue).with(this.yAnchorValue).with(this.xAlignValue).with(this.yAlignValue).with(this.xPosValue).with(this.yPosValue).with(new BooleanValue("config.waila.boss_bars_overlap", WailaConfigScreen.get().getOverlay().getPosition().isBossBarsOverlap(), this.defaultConfig.getOverlay().getPosition().isBossBarsOverlap(), val -> WailaConfigScreen.get().getOverlay().getPosition().setBossBarsOverlap((boolean)val))).with(this.scaleValue).with(this.alphaVal).with(this.themeIdVal);
        this.modNameFormatVal = new InputValue<String>("config.waila.format_mod_name", WailaConfigScreen.get().getFormatter().getModName(), this.defaultConfig.getFormatter().getModName(), val -> WailaConfigScreen.get().getFormatter().setModName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getModName() : val), InputValue.ANY);
        this.blockNameFormatVal = new InputValue<String>("config.waila.format_block_name", WailaConfigScreen.get().getFormatter().getBlockName(), this.defaultConfig.getFormatter().getBlockName(), val -> WailaConfigScreen.get().getFormatter().setBlockName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getBlockName() : val), InputValue.ANY);
        options.with(new CategoryEntry("config.waila.formatting")).with(this.modNameFormatVal).with(this.blockNameFormatVal).with(new InputValue<String>("config.waila.format_fluid_name", WailaConfigScreen.get().getFormatter().getFluidName(), this.defaultConfig.getFormatter().getFluidName(), val -> WailaConfigScreen.get().getFormatter().setFluidName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getFluidName() : val), InputValue.ANY)).with(new InputValue<String>("config.waila.format_entity_name", WailaConfigScreen.get().getFormatter().getEntityName(), this.defaultConfig.getFormatter().getEntityName(), val -> WailaConfigScreen.get().getFormatter().setEntityName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getEntityName() : val), InputValue.ANY)).with(new InputValue<String>("config.waila.format_registry_name", WailaConfigScreen.get().getFormatter().getRegistryName(), this.defaultConfig.getFormatter().getRegistryName(), val -> WailaConfigScreen.get().getFormatter().setRegistryName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getRegistryName() : val), InputValue.ANY));
        options.with(new CategoryEntry("config.waila.keybinds")).with(new KeyBindValue(WailaClient.keyOpenConfig)).with(new KeyBindValue(WailaClient.keyShowOverlay)).with(new KeyBindValue(WailaClient.keyToggleLiquid)).with(new KeyBindValue(WailaClient.keyShowRecipeInput)).with(new KeyBindValue(WailaClient.keyShowRecipeOutput));
        return options;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.selectedKeyBind != null) {
            this.selectedKeyBind.setValue(InputConstants.Type.MOUSE.m_84895_(button));
            this.selectedKeyBind = null;
            return true;
        }
        return this.f1held || super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.selectedKeyBind != null) {
            if (keyCode == 256) {
                this.selectedKeyBind.setValue(InputConstants.f_84822_);
            } else {
                this.selectedKeyBind.setValue(InputConstants.m_84827_((int)keyCode, (int)scanCode));
            }
            this.selectedKeyBind = null;
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private class PreviewTooltipRendererState
    implements TooltipRenderer.State {
        private PreviewTooltipRendererState() {
        }

        @Override
        public boolean render() {
            return true;
        }

        @Override
        public boolean fireEvent() {
            return false;
        }

        private int getAlpha() {
            return DisplayUtil.getAlphaFromPercentage(WailaConfigScreen.this.alphaVal.getValue());
        }

        @Override
        public float getScale() {
            return WailaConfigScreen.this.scaleValue.getValue().floatValue();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAnchor() {
            return WailaConfigScreen.this.xAnchorValue.getValue();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAnchor() {
            return WailaConfigScreen.this.yAnchorValue.getValue();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAlign() {
            return WailaConfigScreen.this.xAlignValue.getValue();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAlign() {
            return WailaConfigScreen.this.yAlignValue.getValue();
        }

        @Override
        public int getX() {
            return WailaConfigScreen.this.xPosValue.getValue();
        }

        @Override
        public int getY() {
            return WailaConfigScreen.this.yPosValue.getValue();
        }

        @Override
        public boolean bossBarsOverlap() {
            return false;
        }

        @Override
        public int getBg() {
            return this.getAlpha() + WailaConfigScreen.this.getTheme().getBackgroundColor();
        }

        @Override
        public int getGradStart() {
            return this.getAlpha() + WailaConfigScreen.this.getTheme().getGradientEnd();
        }

        @Override
        public int getGradEnd() {
            return this.getAlpha() + WailaConfigScreen.this.getTheme().getGradientEnd();
        }

        @Override
        public boolean enableTextToSpeech() {
            return false;
        }

        @Override
        public int getFontColor() {
            return WailaConfigScreen.this.getTheme().getFontColor();
        }
    }

    private class ThemeValue
    extends CycleValue {
        private final Button editButton;
        private final Button newButton;

        public ThemeValue() {
            super("config.waila.overlay_theme", (String[])WailaConfigScreen.get().getOverlay().getColor().themes().values().stream().map(t -> t.getId().toString()).sorted(String::compareToIgnoreCase).toArray(String[]::new), WailaConfigScreen.get().getOverlay().getColor().theme().getId().toString(), val -> WailaConfigScreen.get().getOverlay().getColor().applyTheme(new ResourceLocation(val)), false);
            this.editButton = new Button(0, 0, 40, 20, (Component)new TranslatableComponent("config.waila.edit"), button -> this.client.m_91152_((Screen)new ThemeEditorScreen(WailaConfigScreen.this, WailaConfigScreen.this.getTheme(), true)));
            this.newButton = new Button(0, 0, 40, 20, (Component)new TranslatableComponent("config.waila.new"), button -> this.client.m_91152_((Screen)new ThemeEditorScreen(WailaConfigScreen.this, WailaConfigScreen.this.getTheme(), false)));
            this.editButton.f_93623_ = !((String)this.getValue()).startsWith("waila:");
        }

        @Override
        public void addToScreen(ConfigScreen screen) {
            super.addToScreen(screen);
            screen.addListener((GuiEventListener)this.editButton);
            screen.addListener((GuiEventListener)this.newButton);
        }

        @Override
        public void setValue(String value) {
            super.setValue(value);
            this.editButton.f_93623_ = !value.startsWith("waila:");
        }

        @Override
        protected void drawValue(PoseStack matrices, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.newButton.f_93620_ = x + width - this.newButton.m_5711_();
            this.newButton.f_93621_ = y + (height - this.newButton.m_93694_()) / 2;
            this.editButton.f_93620_ = this.newButton.f_93620_ - this.newButton.m_5711_() - 2;
            this.editButton.f_93621_ = this.newButton.f_93621_;
            this.editButton.m_6305_(matrices, mouseX, mouseY, partialTicks);
            this.newButton.m_6305_(matrices, mouseX, mouseY, partialTicks);
            super.drawValue(matrices, width - 84, height, x, y, mouseX, mouseY, selected, partialTicks);
        }
    }

    public class KeyBindValue
    extends ConfigValue<InputConstants.Key> {
        private final Button button;

        public KeyBindValue(KeyMapping key) {
            super(key.m_90860_(), ((KeyMappingAccess)key).wthit_key(), key.m_90861_(), value -> {
                ((WailaConfigScreen)mcp$mobius$waila$gui$screen$WailaConfigScreen$this).f_96541_.f_91066_.m_92159_(key, value);
                KeyMapping.m_90854_();
            });
            this.button = new Button(0, 0, 100, 20, TextComponent.f_131282_, w -> {
                WailaConfigScreen.this.selectedKeyBind = this;
            });
        }

        @Override
        public GuiEventListener getListener() {
            return this.button;
        }

        @Override
        protected void drawValue(PoseStack matrices, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (WailaConfigScreen.this.selectedKeyBind == this) {
                this.button.m_93666_((Component)new TextComponent("> " + ((InputConstants.Key)this.getValue()).m_84875_().getString() + " <").m_130940_(ChatFormatting.YELLOW));
            } else {
                this.button.m_93666_(((InputConstants.Key)this.getValue()).m_84875_());
            }
            this.button.f_93620_ = x + width - this.button.m_5711_();
            this.button.f_93621_ = y + (height - this.button.m_93694_()) / 2;
            this.button.m_6305_(matrices, mouseX, mouseY, partialTicks);
        }
    }
}

