/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions;

import blusunrize.immersiveengineering.common.crafting.GeneratedListRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.natives.fluid.ExpandFluid;
import java.util.Iterator;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;

public abstract class AbstractActionGenericRemoveRecipe<T extends Recipe<?>>
implements IRuntimeAction {
    private final IRecipeManager<T> manager;
    private final String output;

    public AbstractActionGenericRemoveRecipe(IRecipeManager<T> manager, CommandStringDisplayable output) {
        this(manager, output.getCommandString());
    }

    public AbstractActionGenericRemoveRecipe(IRecipeManager<T> manager, Fluid fluid) {
        this(manager, ExpandFluid.getCommandString((Fluid)fluid));
    }

    public AbstractActionGenericRemoveRecipe(IRecipeManager<T> manager, String output) {
        this.manager = manager;
        this.output = output;
    }

    public void apply() {
        int count = 0;
        Iterator iterator = this.manager.getRecipes().entrySet().iterator();
        try {
            while (iterator.hasNext()) {
                Recipe recipe = (Recipe)iterator.next().getValue();
                if (recipe instanceof GeneratedListRecipe) {
                    CraftTweakerAPI.LOGGER.debug("Skipping GeneratedListRecipe '{}'", (Object)recipe.m_6423_());
                    continue;
                }
                if (!this.shouldRemove(recipe)) continue;
                iterator.remove();
                ++count;
            }
        }
        catch (ClassCastException exception) {
            CraftTweakerAPI.LOGGER.error("There is an illegal entry in " + this.manager.getCommandString() + " that caused an exception: ", (Throwable)exception);
        }
        CraftTweakerAPI.LOGGER.info("Removed {} \"{}\" recipes", (Object)count, (Object)this.manager.getCommandString());
    }

    public abstract boolean shouldRemove(T var1);

    public String describe() {
        return "Removing all \"" + this.manager.getCommandString() + "\" recipes, that output: " + this.output;
    }
}

