/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.oc2;

import blusunrize.immersiveengineering.common.util.compat.computers.generic.CallbackEnvironment;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerCallback;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.EventWaiterResult;
import blusunrize.immersiveengineering.common.util.compat.computers.oc2.IERPCParameter;
import com.google.gson.JsonArray;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc2.api.bus.device.rpc.RPCInvocation;
import li.cil.oc2.api.bus.device.rpc.RPCMethod;
import li.cil.oc2.api.bus.device.rpc.RPCParameter;

public final class IERPCMethod<T>
implements RPCMethod {
    private final ComputerCallback<? super T> callback;
    private final T preprocessed;
    private final RPCParameter[] parameters;
    private final T rawObject;

    public IERPCMethod(ComputerCallback<? super T> callback, T rawObject, T preprocessed) {
        this.callback = callback;
        this.preprocessed = preprocessed;
        this.rawObject = rawObject;
        this.parameters = (RPCParameter[])callback.getUserArguments().stream().map(ComputerCallback.ArgumentType::getActualType).map(IERPCParameter::new).toArray(RPCParameter[]::new);
    }

    @Nonnull
    public String getName() {
        return this.callback.getName();
    }

    public boolean isSynchronized() {
        return !this.callback.isAsync();
    }

    @Nonnull
    public Class<?> getReturnType() {
        return this.callback.getLuaReturnType();
    }

    @Nonnull
    public RPCParameter[] getParameters() {
        return this.parameters;
    }

    @Nullable
    public Object invoke(@Nonnull RPCInvocation rpcInvocation) throws Throwable {
        JsonArray jsonParms = rpcInvocation.getParameters();
        Object[] parameters = new Object[jsonParms.size()];
        for (int i = 0; i < jsonParms.size(); ++i) {
            parameters[i] = rpcInvocation.getGson().fromJson(jsonParms.get(i), this.getParameters()[i].getType());
        }
        Object[] internalResult = this.callback.invoke(parameters, new CallbackEnvironment<T>(this.preprocessed, this.rawObject));
        if (internalResult.length == 0) {
            return null;
        }
        Object object = internalResult[0];
        if (object instanceof EventWaiterResult) {
            EventWaiterResult waiter = (EventWaiterResult)object;
            waiter.runSync();
            return null;
        }
        return internalResult[0];
    }
}

