/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.oc2;

import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.config.CachedConfig;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.CallbackOwner;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.Callbacks;
import blusunrize.immersiveengineering.common.util.compat.computers.oc2.IEDevice;
import blusunrize.immersiveengineering.common.util.compat.computers.oc2.WrappedOwner;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.provider.BlockDeviceQuery;
import li.cil.oc2.api.util.Invalidatable;
import li.cil.oc2.common.bus.device.provider.util.AbstractBlockDeviceProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DeviceProvider
extends AbstractBlockDeviceProvider {
    private final Map<ResourceLocation, WrappedOwner<?>> wrappedOwners;
    private final CachedConfig.BooleanValue enabled;

    public DeviceProvider(CachedConfig.BooleanValue enabled) {
        this.enabled = enabled;
        HashMap map = new HashMap();
        try {
            for (Map.Entry<ResourceLocation, CallbackOwner<?>> e : Callbacks.getCallbacks().entrySet()) {
                map.put(e.getKey(), new WrappedOwner(e.getValue()));
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        this.wrappedOwners = Collections.unmodifiableMap(map);
    }

    @Nonnull
    public Invalidatable<Device> getDevice(@Nonnull BlockDeviceQuery blockDeviceQuery) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return Invalidatable.empty();
        }
        BlockEntity blockEntity = blockDeviceQuery.getLevel().m_7702_(blockDeviceQuery.getQueryPosition());
        if (!(blockEntity instanceof IEBaseBlockEntity)) {
            return Invalidatable.empty();
        }
        IEBaseBlockEntity ieBE = (IEBaseBlockEntity)blockEntity;
        WrappedOwner<?> owner = this.wrappedOwners.get(ieBE.m_58903_().getRegistryName());
        Invalidatable<Device> result = this.getDevice(owner, ieBE);
        if (result.isPresent()) {
            ieBE.addCapInvalidateHook(() -> result.invalidate());
        }
        return result;
    }

    private <T> Invalidatable<Device> getDevice(WrappedOwner<T> owner, BlockEntity actualBE) {
        BlockEntity asT = actualBE;
        if (owner == null || !owner.getOwner().canAttachTo(asT)) {
            return Invalidatable.empty();
        }
        return Invalidatable.of(new IEDevice<BlockEntity>(owner, asT));
    }
}

