/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MissingMappingsHelper {
    private static final Map<ResourceKey<? extends IForgeRegistryEntry<?>>, Supplier<? extends IForgeRegistryEntry<?>>> REMAPPERS = new HashMap();

    public static <T extends IForgeRegistryEntry<T>> void handleRemapping(RegistryEvent.MissingMappings<T> event) {
        ImmutableList mappings = event.getMappings("immersiveengineering");
        IForgeRegistry iForgeRegistry = event.getRegistry();
        if (!(iForgeRegistry instanceof ForgeRegistry)) {
            return;
        }
        ForgeRegistry registry = (ForgeRegistry)iForgeRegistry;
        mappings.forEach(mapping -> {
            Supplier<IForgeRegistryEntry<?>> supplier = REMAPPERS.get(ResourceKey.m_135785_((ResourceKey)registry.getRegistryKey(), (ResourceLocation)mapping.key));
            if (supplier != null) {
                mapping.remap(supplier.get());
            }
        });
    }

    public static <T extends IForgeRegistryEntry<T>> void addRemapping(IForgeRegistry<T> registry, ResourceLocation oldKey, Supplier<T> newSupplier) {
        if (registry instanceof ForgeRegistry) {
            ForgeRegistry forgeRegistry = (ForgeRegistry)registry;
            REMAPPERS.put(ResourceKey.m_135785_((ResourceKey)forgeRegistry.getRegistryKey(), (ResourceLocation)oldKey), newSupplier);
        }
    }
}

