/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.IWireCoil;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireLink;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.api.wires.utils.WirecoilUtils;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.network.MessageObstructedConnection;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;

public class WireCoilItem
extends IEBaseItem
implements IWireCoil {
    @Nonnull
    private final WireType type;

    public WireCoilItem(@Nonnull WireType type) {
        super(new Item.Properties());
        this.type = type;
    }

    @Override
    public WireType getWireType(ItemStack stack) {
        return this.type;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        if ("REDSTONE".equals(this.type.getCategory())) {
            list.add((Component)new TranslatableComponent("desc.immersiveengineering.flavour.coil.redstone"));
            list.add((Component)new TranslatableComponent("desc.immersiveengineering.flavour.coil.construction1"));
        } else if ("STRUCTURE".equals(this.type.getCategory())) {
            list.add((Component)new TranslatableComponent("desc.immersiveengineering.flavour.coil.construction0"));
            list.add((Component)new TranslatableComponent("desc.immersiveengineering.flavour.coil.construction1"));
        }
        if (WirecoilUtils.hasWireLink(stack)) {
            WireLink link = WireLink.readFromItem(stack);
            list.add((Component)new TranslatableComponent("desc.immersiveengineering.info.attachedToDim", new Object[]{link.cp.getX(), link.cp.getY(), link.cp.getZ(), link.dimension}));
        }
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        return WirecoilUtils.doCoilUse(this, ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), ctx.m_43724_(), ctx.m_43719_(), (float)ctx.m_43720_().f_82479_, (float)ctx.m_43720_().f_82480_, (float)ctx.m_43720_().f_82481_);
    }

    public static InteractionResult doCoilUse(IWireCoil coil, Player player, Level world, BlockPos pos, InteractionHand hand, Direction side, float hitX, float hitY, float hitZ) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntity).canConnect()) {
            IImmersiveConnectable iicHere;
            ItemStack stack = player.m_21120_(hand);
            TargetingInfo targetHere = new TargetingInfo(side, hitX - (float)pos.m_123341_(), hitY - (float)pos.m_123342_(), hitZ - (float)pos.m_123343_());
            WireType wire = coil.getWireType(stack);
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(wire, targetHere);
            BlockPos masterOffsetHere = pos.m_141950_((Vec3i)masterPos);
            tileEntity = world.m_7702_(masterPos);
            if (!(tileEntity instanceof IImmersiveConnectable) || !(iicHere = (IImmersiveConnectable)tileEntity).canConnect()) {
                return InteractionResult.PASS;
            }
            ConnectionPoint cpHere = iicHere.getTargetedPoint(targetHere, (Vec3i)masterOffsetHere);
            if (cpHere == null || !iicHere.canConnectCable(wire, cpHere, (Vec3i)masterOffsetHere) || !coil.canConnectCable(stack, tileEntity)) {
                if (!world.f_46443_) {
                    player.m_5661_((Component)new TranslatableComponent("chat.immersiveengineering.warning.wrongCable"), true);
                }
                return InteractionResult.FAIL;
            }
            if (!world.f_46443_) {
                if (!WirecoilUtils.hasWireLink(stack)) {
                    WireLink link = WireLink.create(cpHere, world, masterOffsetHere, targetHere);
                    link.writeToItem(stack);
                } else {
                    WireLink otherLink = WireLink.readFromItem(stack);
                    BlockEntity tileEntityLinkingPos = world.m_7702_(otherLink.cp.position());
                    int distanceSq = (int)Math.ceil(otherLink.cp.position().m_123331_((Vec3i)masterPos));
                    int maxLengthSq = coil.getMaxLength(stack);
                    maxLengthSq *= maxLengthSq;
                    if (!otherLink.dimension.equals((Object)world.m_46472_())) {
                        player.m_5661_((Component)new TranslatableComponent("chat.immersiveengineering.warning.wrongDimension"), true);
                    } else if (otherLink.cp.position().equals((Object)masterPos)) {
                        player.m_5661_((Component)new TranslatableComponent("chat.immersiveengineering.warning.sameConnection"), true);
                    } else if (distanceSq > maxLengthSq) {
                        player.m_5661_((Component)new TranslatableComponent("chat.immersiveengineering.warning.tooFar"), true);
                    } else if (!(tileEntityLinkingPos instanceof IImmersiveConnectable)) {
                        player.m_5661_((Component)new TranslatableComponent("chat.immersiveengineering.warning.invalidPoint"), true);
                    } else {
                        IImmersiveConnectable iicLink = (IImmersiveConnectable)tileEntityLinkingPos;
                        if (!(iicLink.canConnectCable(wire, otherLink.cp, (Vec3i)otherLink.offset) && iicLink.getConnectionMaster(wire, otherLink.target).equals((Object)otherLink.cp.position()) && coil.canConnectCable(stack, tileEntityLinkingPos))) {
                            player.m_5661_((Component)new TranslatableComponent("chat.immersiveengineering.warning.invalidPoint"), true);
                        } else {
                            Collection<Connection> outputs;
                            LocalWireNetwork localB;
                            GlobalWireNetwork net = GlobalWireNetwork.getNetwork(world);
                            boolean connectionExists = false;
                            LocalWireNetwork localA = net.getLocalNet(cpHere);
                            if (localA == (localB = net.getLocalNet(otherLink.cp)) && (outputs = localA.getConnections(cpHere)) != null) {
                                for (Connection con : outputs) {
                                    if (con.isInternal() || !con.getOtherEnd(cpHere).equals(otherLink.cp)) continue;
                                    connectionExists = true;
                                }
                            }
                            if (connectionExists) {
                                player.m_5661_((Component)new TranslatableComponent("chat.immersiveengineering.warning.connectionExists"), true);
                            } else {
                                HashSet<BlockPos> ignore = new HashSet<BlockPos>();
                                ignore.addAll(iicHere.getIgnored(iicLink));
                                ignore.addAll(iicLink.getIgnored(iicHere));
                                Connection conn = new Connection(wire, cpHere, otherLink.cp, net);
                                Set<BlockPos> failedReasons = WireUtils.findObstructingBlocks(world, conn, ignore);
                                if (failedReasons.isEmpty()) {
                                    net.addConnection(conn);
                                    iicHere.connectCable(wire, cpHere, iicLink, otherLink.cp);
                                    iicLink.connectCable(wire, otherLink.cp, iicHere, cpHere);
                                    Utils.unlockIEAdvancement(player, "main/connect_wire");
                                    if (!player.m_150110_().f_35937_) {
                                        coil.consumeWire(stack, (int)Math.sqrt(distanceSq));
                                    }
                                    ((BlockEntity)iicHere).m_6596_();
                                    world.m_7696_(masterPos, ((BlockEntity)iicHere).m_58900_().m_60734_(), -1, 0);
                                    BlockState state = world.m_8055_(masterPos);
                                    world.m_7260_(masterPos, state, state, 3);
                                    ((BlockEntity)iicLink).m_6596_();
                                    world.m_7696_(otherLink.cp.position(), tileEntityLinkingPos.m_58900_().m_60734_(), -1, 0);
                                    state = world.m_8055_(otherLink.cp.position());
                                    world.m_7260_(otherLink.cp.position(), state, state, 3);
                                } else {
                                    player.m_5661_((Component)new TranslatableComponent("chat.immersiveengineering.warning.cantSee"), true);
                                    ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageObstructedConnection(conn, failedReasons));
                                }
                            }
                        }
                    }
                    WirecoilUtils.clearWireLink(stack);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

