/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.register.IEContainerTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.network.NetworkHooks;

public class IEBaseItem
extends Item {
    private int burnTime = -1;
    private boolean isHidden = false;

    public IEBaseItem() {
        this(new Item.Properties());
    }

    public IEBaseItem(Item.Properties props) {
        this(props, ImmersiveEngineering.ITEM_GROUP);
    }

    public IEBaseItem(Item.Properties props, CreativeModeTab group) {
        super(props.m_41491_(group));
    }

    public IEBaseItem setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> type) {
        return this.burnTime;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    protected void openGui(Player player, InteractionHand hand) {
        this.openGui(player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
    }

    protected void openGui(Player player, final EquipmentSlot slot) {
        final ItemStack stack = player.m_6844_(slot);
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

            @Nonnull
            public Component m_5446_() {
                return new TextComponent("");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
                if (!(stack.m_41720_() instanceof IEBaseItem)) {
                    return null;
                }
                IEContainerTypes.ItemContainerType<?> containerType = ((IEBaseItem)stack.m_41720_()).getContainerType();
                if (containerType == null) {
                    return null;
                }
                return containerType.create(i, playerInventory, playerEntity.f_19853_, slot, stack);
            }
        }, buffer -> buffer.writeInt(slot.ordinal()));
    }

    public boolean isRepairable(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean isIERepairable(@Nonnull ItemStack stack) {
        return super.isRepairable(stack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @Nullable
    protected IEContainerTypes.ItemContainerType<?> getContainerType() {
        return null;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return Mob.m_147233_((ItemStack)stack) == armorType || this.getEquipmentSlot(stack) == armorType;
    }

    public int m_142159_(ItemStack pStack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)this.m_142158_(pStack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

