/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.entities.IEProjectileEntity;
import blusunrize.immersiveengineering.common.register.IEEntityDataSerializers;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import javax.annotation.Nonnull;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidStack;

public class ChemthrowerShotEntity
extends IEProjectileEntity {
    @Nonnull
    private FluidStack fluid = FluidStack.EMPTY;
    private static final EntityDataAccessor<FluidStack> dataMarker_fluid = SynchedEntityData.m_135353_(ChemthrowerShotEntity.class, IEEntityDataSerializers.FLUID_STACK);

    public ChemthrowerShotEntity(EntityType<ChemthrowerShotEntity> type, Level world) {
        super(type, world);
    }

    public ChemthrowerShotEntity(Level world, double x, double y, double z, @Nonnull FluidStack fluid) {
        super((EntityType<? extends IEProjectileEntity>)((EntityType)IEEntityTypes.CHEMTHROWER_SHOT.get()), world, x, y, z);
        this.fluid = fluid;
        this.setFluidSynced();
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public ChemthrowerShotEntity(Level world, LivingEntity living, double ax, double ay, double az, @Nonnull FluidStack fluid) {
        super((EntityType<? extends IEProjectileEntity>)((EntityType)IEEntityTypes.CHEMTHROWER_SHOT.get()), world, living, ax, ay, az);
        this.fluid = fluid;
        this.setFluidSynced();
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(dataMarker_fluid, (Object)FluidStack.EMPTY);
    }

    public void setFluidSynced() {
        this.f_19804_.m_135381_(dataMarker_fluid, (Object)this.getFluid());
    }

    @Nonnull
    public FluidStack getFluidSynced() {
        return (FluidStack)this.f_19804_.m_135370_(dataMarker_fluid);
    }

    @Nonnull
    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public double getGravity() {
        if (this.getFluid().isEmpty()) {
            return super.getGravity();
        }
        FluidStack fluidStack = this.getFluid();
        boolean isGas = fluidStack.getFluid().getAttributes().isGaseous(fluidStack);
        return (isGas ? 0.025f : 0.05f) * (float)(fluidStack.getFluid().getAttributes().getDensity(fluidStack) < 0 ? -1 : 1);
    }

    @Override
    public boolean canIgnite() {
        return ChemthrowerHandler.isFlammable(this.getFluid().getFluid());
    }

    public void m_6075_() {
        if (this.f_19853_.f_46443_) {
            this.fluid = this.getFluidSynced();
        }
        BlockState state = this.f_19853_.m_8055_(this.m_142538_());
        if (this.canIgnite() && (state.m_60767_() == Material.f_76309_ || state.m_60767_() == Material.f_76307_)) {
            this.m_20254_(6);
        }
        super.m_6075_();
    }

    public void m_20254_(int seconds) {
        if (!this.canIgnite()) {
            return;
        }
        super.m_20254_(seconds);
    }

    @Override
    public void m_6532_(HitResult mop) {
        boolean fire;
        if (this.f_19853_.f_46443_ || this.getFluid().isEmpty()) {
            return;
        }
        FluidStack fluidStack = this.getFluid();
        Fluid fluid = fluidStack.getFluid();
        ChemthrowerHandler.ChemthrowerEffect effect = ChemthrowerHandler.getEffect(fluid);
        boolean bl = fire = fluid.getAttributes().getTemperature(fluidStack) > 1000;
        if (effect != null) {
            ItemStack thrower = ItemStack.f_41583_;
            Player shooter = (Player)this.m_37282_();
            if (shooter != null) {
                thrower = shooter.m_21120_(InteractionHand.MAIN_HAND);
            }
            if (mop.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)mop).m_82443_() instanceof LivingEntity) {
                effect.applyToEntity((LivingEntity)((EntityHitResult)mop).m_82443_(), shooter, thrower, fluidStack);
            } else if (mop.m_6662_() == HitResult.Type.BLOCK) {
                effect.applyToBlock(this.f_19853_, mop, shooter, thrower, fluidStack);
            }
        } else if (mop.m_6662_() == HitResult.Type.ENTITY && fluid.getAttributes().getTemperature(fluidStack) > 500) {
            int tempDiff = fluid.getAttributes().getTemperature(fluidStack) - 300;
            int damage = Math.abs(tempDiff) / 500;
            Entity hit = ((EntityHitResult)mop).m_82443_();
            if (hit.m_6469_(DamageSource.f_19308_, (float)damage)) {
                hit.f_19802_ = (int)((double)hit.f_19802_ * 0.75);
            }
        }
        if (mop.m_6662_() == HitResult.Type.ENTITY) {
            int f;
            int n = this.m_6060_() ? this.m_20094_() : (f = fire ? 3 : 0);
            if (f > 0) {
                Entity hit = ((EntityHitResult)mop).m_82443_();
                hit.m_20254_(f);
                if (hit.m_6469_(DamageSource.f_19305_, 2.0f)) {
                    hit.f_19802_ = (int)((double)hit.f_19802_ * 0.75);
                }
            }
        }
    }

    public int getBrightnessForRender() {
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            int light = this.m_6060_() ? 15 : fluidStack.getFluid().getAttributes().getLuminosity(fluidStack);
            int superBrightness = 0;
            if ((light = superBrightness & 0xFF00000 | light << 4) > 0) {
                return Math.max(light, superBrightness);
            }
        }
        return 0;
    }

    public float m_6073_() {
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            int light;
            int n = light = this.m_6060_() ? 15 : fluidStack.getFluid().getAttributes().getLuminosity(fluidStack);
            if (light > 0) {
                return Math.max((float)light, super.m_6073_());
            }
        }
        return super.m_6073_();
    }
}

