/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.common.crafting.DamageToolRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DamageToolRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<DamageToolRecipe> {
    @Nonnull
    public DamageToolRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        NonNullList<Ingredient> defIngredients = DamageToolRecipeSerializer.readIngredients(json.getAsJsonArray("ingredients"));
        Ingredient tool = Ingredient.m_43917_((JsonElement)json.get("tool"));
        String group = json.get("group").getAsString();
        ItemStack result = ShapedRecipe.m_151274_((JsonObject)json.getAsJsonObject("result"));
        return new DamageToolRecipe(recipeId, group, result, tool, defIngredients);
    }

    @Nonnull
    public DamageToolRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        int stdCount = buffer.readInt();
        NonNullList stdIngr = NonNullList.m_122779_();
        for (int i = 0; i < stdCount; ++i) {
            stdIngr.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        Ingredient tool = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        String group = buffer.m_130136_(512);
        ItemStack output = buffer.m_130267_();
        return new DamageToolRecipe(recipeId, group, output, tool, (NonNullList<Ingredient>)stdIngr);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull DamageToolRecipe recipe) {
        int standardCount = recipe.m_7527_().size() - 1;
        buffer.writeInt(standardCount);
        for (int i = 0; i < standardCount; ++i) {
            CraftingHelper.write((FriendlyByteBuf)buffer, (Ingredient)((Ingredient)recipe.m_7527_().get(i)));
        }
        CraftingHelper.write((FriendlyByteBuf)buffer, (Ingredient)recipe.getTool());
        buffer.m_130070_(recipe.m_6076_());
        buffer.m_130055_(recipe.m_8043_());
    }

    private static NonNullList<Ingredient> readIngredients(JsonArray all) {
        NonNullList ret = NonNullList.m_122779_();
        for (int i = 0; i < all.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)all.get(i));
            if (ingredient.m_43947_()) continue;
            ret.add((Object)ingredient);
        }
        return ret;
    }
}

