/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.crafting.CokeOvenRecipe;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.register.IEContainerTypes;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CokeOvenBlockEntity
extends MultiblockPartBlockEntity<CokeOvenBlockEntity>
implements IIEInventory,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IInteractionObjectIE<CokeOvenBlockEntity>,
IEBlockInterfaces.IProcessBE,
IEBlockInterfaces.IBlockBounds,
IEClientTickableBE {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public static final int EMPTY_CONTAINER_SLOT = 2;
    public static final int FULL_CONTAINER_SLOT = 3;
    public FluidTank tank = new FluidTank(12000);
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final Supplier<CokeOvenRecipe> cachedRecipe = CachedRecipe.cached(CokeOvenRecipe::findRecipe, () -> this.f_58857_, () -> (ItemStack)this.inventory.get(0));
    public int process = 0;
    public int processMax = 0;
    public CokeOvenData guiData = new CokeOvenData();
    private final MultiblockCapability<IItemHandler> invHandler = MultiblockCapability.make(this, be -> be.invHandler, MultiblockPartBlockEntity::master, this.registerCapability(new IEInventoryHandler(4, (IIEInventory)this, 0, new boolean[]{true, false, true, false}, new boolean[]{false, true, false, true})));
    private final MultiblockCapability<IFluidHandler> fluidCap = MultiblockCapability.make(this, be -> be.fluidCap, MultiblockPartBlockEntity::master, this.registerFluidOutput(new IFluidTank[]{this.tank}));

    public CokeOvenBlockEntity(BlockEntityType<CokeOvenBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.COKE_OVEN, type, false, pos, state);
    }

    @Override
    public boolean canUseGui(Player player) {
        return this.formed;
    }

    @Override
    public CokeOvenBlockEntity getGuiMaster() {
        return (CokeOvenBlockEntity)this.master();
    }

    @Override
    public IEContainerTypes.BEContainer<CokeOvenBlockEntity, ?> getContainerType() {
        return IEContainerTypes.COKE_OVEN;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return Shapes.m_83144_();
    }

    @Override
    public void tickClient() {
        if (this.getLevelNonnull().f_46441_.nextInt(24) == 0 && this.getIsActive()) {
            this.getLevelNonnull().m_7785_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 0.5f + this.getLevelNonnull().f_46441_.nextFloat() * 0.5f, this.getLevelNonnull().f_46441_.nextFloat() * 0.7f + 0.3f, false);
        }
    }

    @Override
    public void tickServer() {
        boolean activeAfterTick;
        boolean activeBeforeTick = this.getIsActive();
        if (this.process > 0) {
            if (((ItemStack)this.inventory.get(0)).m_41619_()) {
                this.process = 0;
                this.processMax = 0;
            } else {
                recipe = this.getRecipe();
                if (recipe == null || recipe.time != this.processMax) {
                    this.process = 0;
                    this.processMax = 0;
                    this.setActive(false);
                } else {
                    --this.process;
                }
            }
            this.m_6596_();
        } else {
            if (activeBeforeTick) {
                recipe = this.getRecipe();
                if (recipe != null) {
                    Utils.modifyInvStackSize(this.inventory, 0, -recipe.input.getCount());
                    if (!((ItemStack)this.inventory.get(1)).m_41619_()) {
                        ((ItemStack)this.inventory.get(1)).m_41769_(((ItemStack)recipe.output.get()).m_41777_().m_41613_());
                    } else if (((ItemStack)this.inventory.get(1)).m_41619_()) {
                        this.inventory.set(1, (Object)((ItemStack)recipe.output.get()).m_41777_());
                    }
                    this.tank.fill(new FluidStack((Fluid)IEFluids.CREOSOTE.getStill(), recipe.creosoteOutput), IFluidHandler.FluidAction.EXECUTE);
                }
                this.processMax = 0;
                this.setActive(false);
            }
            if ((recipe = this.getRecipe()) != null) {
                this.processMax = this.process = recipe.time;
                this.setActive(true);
            }
        }
        if (this.tank.getFluidAmount() > 0) {
            if (FluidUtils.fillFluidContainer((IFluidHandler)this.tank, 2, 3, arg_0 -> this.inventory.get(arg_0), (arg_0, arg_1) -> this.inventory.set(arg_0, arg_1))) {
                this.m_6596_();
            }
        }
        if (activeBeforeTick != (activeAfterTick = this.getIsActive())) {
            this.m_6596_();
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    for (int z = 0; z < 3; ++z) {
                        BlockPos actualPos = this.getBlockPosForPos(new BlockPos(x, y, z));
                        BlockEntity te = Utils.getExistingTileEntity(this.f_58857_, actualPos);
                        if (!(te instanceof CokeOvenBlockEntity)) continue;
                        ((CokeOvenBlockEntity)te).setActive(activeAfterTick);
                    }
                }
            }
        }
    }

    @Nullable
    public CokeOvenRecipe getRecipe() {
        CokeOvenRecipe recipe = this.cachedRecipe.get();
        if (recipe == null) {
            return null;
        }
        if ((((ItemStack)this.inventory.get(1)).m_41619_() || ItemStack.m_41746_((ItemStack)((ItemStack)this.inventory.get(1)), (ItemStack)((ItemStack)recipe.output.get())) && ((ItemStack)this.inventory.get(1)).m_41613_() + ((ItemStack)recipe.output.get()).m_41613_() <= this.getSlotLimit(1)) && this.tank.getFluidAmount() + recipe.creosoteOutput <= this.tank.getCapacity()) {
            return recipe;
        }
        return null;
    }

    @Override
    public int[] getCurrentProcessesStep() {
        CokeOvenBlockEntity master = (CokeOvenBlockEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        return new int[]{this.processMax - this.process};
    }

    @Override
    public int[] getCurrentProcessesMax() {
        CokeOvenBlockEntity master = (CokeOvenBlockEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        return new int[]{this.processMax};
    }

    @Override
    public boolean m_7531_(int id, int arg) {
        if (id == 0) {
            this.formed = arg == 1;
        }
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
            this.process = nbt.m_128451_("process");
            this.processMax = nbt.m_128451_("processMax");
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket) {
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128405_("process", this.process);
            nbt.m_128405_("processMax", this.processMax);
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        CokeOvenBlockEntity master = (CokeOvenBlockEntity)this.master();
        if (master != null && master.formed && this.formed) {
            return master.inventory;
        }
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (slot == 0) {
            return CokeOvenRecipe.findRecipe(this.f_58857_, stack) != null;
        }
        if (slot == 2) {
            return Utils.isFluidRelatedItemStack(stack);
        }
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.getAndCast();
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.invHandler.getAndCast();
        }
        return super.getCapability(capability, facing);
    }

    public class CokeOvenData
    implements ContainerData {
        public static final int MAX_BURN_TIME = 0;
        public static final int BURN_TIME = 1;

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return CokeOvenBlockEntity.this.processMax;
                }
                case 1: {
                    return CokeOvenBlockEntity.this.process;
                }
            }
            throw new IllegalArgumentException("Unknown index " + index);
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CokeOvenBlockEntity.this.processMax = value;
                    break;
                }
                case 1: {
                    CokeOvenBlockEntity.this.process = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown index " + index);
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    }
}

