/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.BucketWheelBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import blusunrize.immersiveengineering.common.util.FakePlayerUtil;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;

public class ExcavatorBlockEntity
extends PoweredMultiblockBlockEntity<ExcavatorBlockEntity, MultiblockRecipe>
implements IEBlockInterfaces.IBlockBounds {
    private static final BlockPos wheelCenterOffset = new BlockPos(1, 1, 1);
    public boolean active = false;
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(ExcavatorBlockEntity::getShape);
    private CapabilityReference<IItemHandler> output = CapabilityReference.forBlockEntityAt(this, () -> new DirectionalBlockPos(this.m_58899_().m_5484_(this.getFacing(), -1), this.getFacing().m_122424_()), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);

    public ExcavatorBlockEntity(BlockEntityType<ExcavatorBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.EXCAVATOR, 64000, true, type, pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
    }

    public BlockPos getWheelCenterPos() {
        return this.getBlockPosForPos(wheelCenterOffset);
    }

    @Override
    protected int getComparatorValueOnMaster() {
        BlockPos wheelPos = this.getWheelCenterPos();
        if (SafeChunkUtils.getSafeBE((LevelAccessor)this.f_58857_, wheelPos) instanceof BucketWheelBlockEntity) {
            MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(this.f_58857_, wheelPos);
            if (info == null) {
                return 0;
            }
            if (ExcavatorHandler.mineralVeinYield == 0) {
                return 15;
            }
            long totalDepletion = 0L;
            List<Pair<MineralVein, Integer>> veins = info.getAllVeins();
            if (veins.isEmpty()) {
                return 0;
            }
            for (Pair<MineralVein, Integer> pair : veins) {
                totalDepletion += (long)((MineralVein)pair.getFirst()).getDepletion();
            }
            float remain = (float)((long)ExcavatorHandler.mineralVeinYield - (totalDepletion /= (long)veins.size())) / (float)ExcavatorHandler.mineralVeinYield;
            return Mth.m_14167_((float)(Math.max(remain, 0.0f) * 15.0f));
        }
        return 0;
    }

    @Override
    public void tickServer() {
        BlockEntity center;
        super.tickServer();
        BlockPos wheelPos = this.getBlockPosForPos(wheelCenterOffset);
        if (this.f_58857_.isAreaLoaded(wheelPos, 5) && (center = this.f_58857_.m_7702_(wheelPos)) instanceof BucketWheelBlockEntity) {
            BucketWheelBlockEntity wheel = (BucketWheelBlockEntity)center;
            if (wheel != wheel.master()) {
                return;
            }
            float rot = 0.0f;
            int target = -1;
            Direction fRot = this.getFacing().m_122428_();
            boolean mirrored = this.getIsMirrored();
            if (wheel.getFacing() == fRot && wheel.getIsMirrored() == mirrored) {
                if (this.active != wheel.active) {
                    this.f_58857_.m_7696_(wheel.m_58899_(), wheel.m_58900_().m_60734_(), 0, this.active ? 1 : 0);
                }
                if ((rot = wheel.rotation) % 45.0f > 40.0f) {
                    target = Math.round(rot / 360.0f * 8.0f) % 8;
                }
            } else {
                wheel.adjustStructureFacingAndMirrored(fRot, mirrored);
            }
            if (!this.isRSDisabled()) {
                MineralVein mineralVein = ExcavatorHandler.getRandomMineral(this.f_58857_, wheelPos);
                MineralMix mineral = mineralVein != null ? mineralVein.getMineral(this.f_58857_) : null;
                int consumed = (Integer)IEServerConfig.MACHINES.excavator_consumption.get();
                int extracted = this.energyStorage.extractEnergy(consumed, true);
                if (extracted >= consumed) {
                    this.energyStorage.extractEnergy(consumed, false);
                    this.active = true;
                    if (target >= 0) {
                        int targetDown = (target + 4) % 8;
                        CompoundTag packet = new CompoundTag();
                        if (((ItemStack)wheel.digStacks.get(targetDown)).m_41619_()) {
                            ItemStack blocking = this.digBlocksInTheWay(wheel);
                            if (!blocking.m_41619_()) {
                                wheel.digStacks.set(targetDown, (Object)blocking);
                                wheel.m_6596_();
                                this.markContainingBlockForUpdate(null);
                            } else if (mineral != null) {
                                this.fillBucket(mineralVein, mineral, wheelPos, wheel, targetDown);
                                mineralVein.deplete();
                            }
                            if (!((ItemStack)wheel.digStacks.get(targetDown)).m_41619_()) {
                                packet.m_128405_("fill", targetDown);
                                packet.m_128365_("fillStack", (Tag)((ItemStack)wheel.digStacks.get(targetDown)).m_41739_(new CompoundTag()));
                            }
                        }
                        if (!((ItemStack)wheel.digStacks.get(target)).m_41619_()) {
                            this.doProcessOutput(((ItemStack)wheel.digStacks.get(target)).m_41777_());
                            Block b = Block.m_49814_((Item)((ItemStack)wheel.digStacks.get(target)).m_41720_());
                            if (b != Blocks.f_50016_) {
                                wheel.spawnParticles((ItemStack)wheel.digStacks.get(target));
                            }
                            wheel.digStacks.set(target, (Object)ItemStack.f_41583_);
                            wheel.m_6596_();
                            this.markContainingBlockForUpdate(null);
                            packet.m_128405_("empty", target);
                        }
                        if (!packet.m_128456_()) {
                            packet.m_128405_("rotation", (int)wheel.rotation);
                            ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new MessageBlockEntitySync(wheel, packet));
                        }
                    }
                } else if (this.active) {
                    this.active = false;
                }
            } else if (this.active) {
                this.active = false;
            }
        }
    }

    ItemStack digBlocksInTheWay(BucketWheelBlockEntity wheel) {
        BlockPos pos = wheel.m_58899_().m_142082_(0, -4, 0);
        ItemStack s = this.digBlock(pos);
        if (!s.m_41619_()) {
            return s;
        }
        s = this.digBlock(pos.m_5484_(this.getFacing(), -1));
        if (!s.m_41619_()) {
            return s;
        }
        s = this.digBlock(pos.m_5484_(this.getFacing(), -2));
        if (!s.m_41619_()) {
            return s;
        }
        s = this.digBlock(pos.m_5484_(this.getFacing(), 1));
        if (!s.m_41619_()) {
            return s;
        }
        s = this.digBlock(pos.m_5484_(this.getFacing(), 2));
        if (!s.m_41619_()) {
            return s;
        }
        s = this.digBlock(pos.m_5484_(this.getFacing(), -1).m_142300_(this.getFacing().m_122427_()));
        if (!s.m_41619_()) {
            return s;
        }
        s = this.digBlock(pos.m_5484_(this.getFacing(), -1).m_142300_(this.getFacing().m_122428_()));
        if (!s.m_41619_()) {
            return s;
        }
        s = this.digBlock(pos.m_142300_(this.getFacing().m_122427_()));
        if (!s.m_41619_()) {
            return s;
        }
        s = this.digBlock(pos.m_142300_(this.getFacing().m_122428_()));
        if (!s.m_41619_()) {
            return s;
        }
        s = this.digBlock(pos.m_5484_(this.getFacing(), 1).m_142300_(this.getFacing().m_122427_()));
        if (!s.m_41619_()) {
            return s;
        }
        s = this.digBlock(pos.m_5484_(this.getFacing(), 1).m_142300_(this.getFacing().m_122428_()));
        if (!s.m_41619_()) {
            return s;
        }
        return ItemStack.f_41583_;
    }

    ItemStack digBlock(BlockPos pos) {
        if (!(this.f_58857_ instanceof ServerLevel)) {
            return ItemStack.f_41583_;
        }
        FakePlayer fakePlayer = FakePlayerUtil.getFakePlayer(this.f_58857_);
        BlockState blockstate = this.f_58857_.m_8055_(pos);
        Block block = blockstate.m_60734_();
        if (!this.f_58857_.m_46859_(pos) && blockstate.m_60800_((BlockGetter)this.f_58857_, pos) != -1.0f) {
            if (!block.canHarvestBlock(blockstate, (BlockGetter)this.f_58857_, pos, (Player)fakePlayer)) {
                return ItemStack.f_41583_;
            }
            if (block.onDestroyedByPlayer(blockstate, this.f_58857_, pos, (Player)fakePlayer, true, blockstate.m_60819_())) {
                block.m_6786_((LevelAccessor)this.f_58857_, pos, blockstate);
                ItemStack tool = new ItemStack((ItemLike)Items.f_42385_);
                tool.m_41663_(Enchantments.f_44985_, 1);
                LootContext.Builder dropContext = new LootContext.Builder((ServerLevel)this.f_58857_).m_78984_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78984_(LootContextParams.f_81463_, (Object)tool);
                List itemsNullable = blockstate.m_60724_(dropContext);
                NonNullList items = NonNullList.m_122779_();
                items.addAll((Collection)itemsNullable);
                for (int i = 0; i < items.size(); ++i) {
                    if (i == 0) continue;
                    ItemEntity ei = new ItemEntity(this.f_58857_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, ((ItemStack)items.get(i)).m_41777_());
                    this.f_58857_.m_7967_((Entity)ei);
                }
                this.f_58857_.m_46796_(2001, pos, Block.m_49956_((BlockState)blockstate));
                if (items.size() > 0) {
                    return (ItemStack)items.get(0);
                }
            }
        }
        return ItemStack.f_41583_;
    }

    private void fillBucket(MineralVein mineralVein, MineralMix mineralMix, BlockPos wheelPos, BucketWheelBlockEntity wheel, int targetDown) {
        if (mineralVein.isDepleted()) {
            return;
        }
        ItemStack ore = mineralMix.getRandomOre(Utils.RAND);
        if (ore.m_41619_()) {
            return;
        }
        if (Utils.RAND.nextFloat() < mineralMix.failChance || (double)Utils.RAND.nextFloat() < mineralVein.getFailChance(wheelPos)) {
            wheel.digStacks.set(targetDown, (Object)mineralMix.getRandomSpoil(Utils.RAND));
        } else {
            wheel.digStacks.set(targetDown, (Object)ore);
        }
        wheel.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return this.getShape(SHAPES);
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        if (posInMultiblock.m_123341_() == 2 && posInMultiblock.m_123343_() == 4) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0), (Object)new AABB(0.5, 0.25, 0.25, 1.0, 0.75, 0.75));
        }
        if (posInMultiblock.m_123343_() < 3 && posInMultiblock.m_123342_() == 0 && posInMultiblock.m_123341_() == 0) {
            ArrayList list = Lists.newArrayList((Object[])new AABB[]{new AABB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0)});
            if (posInMultiblock.m_123343_() == 2) {
                list.add(new AABB(0.0, 0.5, 0.0, 0.5, 1.0, 0.5));
            } else if (posInMultiblock.m_123343_() == 1) {
                list.add(new AABB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0));
            } else {
                list.add(new AABB(0.0, 0.5, 0.5, 0.5, 1.0, 1.0));
            }
            return list;
        }
        if (new BlockPos(2, 2, 2).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.375, 1.0, 1.0, 0.5), (Object)new AABB(0.875, 0.0, 0.0, 1.0, 1.0, 0.375));
        }
        if (new BlockPos(2, 2, 0).equals((Object)posInMultiblock)) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.5, 1.0, 1.0, 0.625), (Object)new AABB(0.875, 0.0, 0.625, 1.0, 1.0, 1.0));
        }
        AABB ret = new BlockPos(0, 2, 2).equals((Object)posInMultiblock) ? new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5) : (new BlockPos(0, 2, 1).equals((Object)posInMultiblock) ? new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0) : (new BlockPos(0, 2, 0).equals((Object)posInMultiblock) ? new AABB(0.0, 0.0, 0.5, 1.0, 0.5, 1.0) : (new BlockPos(2, 2, 2).equals((Object)posInMultiblock) ? new AABB(0.0, 0.0, 0.375, 1.0, 1.0, 0.5) : (new BlockPos(2, 2, 1).equals((Object)posInMultiblock) ? new AABB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0) : (new BlockPos(2, 2, 0).equals((Object)posInMultiblock) ? new AABB(0.0, 0.0, 0.5, 1.0, 1.0, 0.625) : (posInMultiblock.m_123341_() == 2 && posInMultiblock.m_123343_() == 4 ? new AABB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0) : (posInMultiblock.m_123343_() < 3 && posInMultiblock.m_123342_() == 0 && posInMultiblock.m_123341_() == 0 ? new AABB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0) : (posInMultiblock.m_123343_() < 3 && posInMultiblock.m_123342_() == 0 && posInMultiblock.m_123341_() == 2 ? new AABB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0) : new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)))))))));
        return ImmutableList.of((Object)ret);
    }

    @Override
    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(2, 0, 4, RelativeBlockFace.RIGHT), (Object)new PoweredMultiblockBlockEntity.MultiblockFace(2, 1, 4, RelativeBlockFace.RIGHT), (Object)new PoweredMultiblockBlockEntity.MultiblockFace(2, 2, 4, RelativeBlockFace.RIGHT));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(0, 1, 5));
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return false;
    }

    @Override
    public boolean additionalCanProcessCheck(MultiblockProcess<MultiblockRecipe> process) {
        return false;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.output, output, false)).m_41619_()) {
            Utils.dropStackAtPos(this.f_58857_, this.m_58899_().m_5484_(this.getFacing(), -1), output, this.getFacing());
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(MultiblockProcess<MultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 0;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 0;
    }

    @Override
    public float getMinProcessDistance(MultiblockProcess<MultiblockRecipe> process) {
        return 0.0f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected MultiblockRecipe getRecipeForId(Level level, ResourceLocation id) {
        return null;
    }

    @Override
    public void disassemble() {
        super.disassemble();
        BlockPos wheelPos = this.getBlockPosForPos(wheelCenterOffset);
        BlockEntity center = this.f_58857_.m_7702_(wheelPos);
        if (center instanceof BucketWheelBlockEntity) {
            this.f_58857_.m_7696_(center.m_58899_(), center.m_58900_().m_60734_(), 0, 0);
        }
    }
}

