/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.BatchingRenderTypeBuffer;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.blocks.metal.BottlingMachineBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class BottlingMachineRenderer
extends IEBlockEntityRenderer<BottlingMachineBlockEntity> {
    public static final String NAME = "bottling_machine_dynamic";
    public static DynamicModel DYNAMIC;

    public void render(BottlingMachineBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!te.formed || te.isDummy() || !te.getLevelNonnull().m_46805_(te.m_58899_())) {
            return;
        }
        BlockPos blockPos = te.m_58899_();
        BlockState state = te.m_58904_().m_8055_(blockPos);
        if (state.m_60734_() != IEBlocks.Multiblocks.BOTTLING_MACHINE.get()) {
            return;
        }
        Direction facing = te.getFacing();
        float pixelHeight = 0.0625f;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        MultiBufferSource originalBuffer = bufferIn;
        bufferIn = BERenderUtils.mirror(te, matrixStack, bufferIn);
        float[][] itemDisplays = new float[te.processQueue.size()][];
        float lift = 0.0f;
        VertexConsumer solidBuilder = bufferIn.m_6299_(RenderType.m_110451_());
        for (int i = 0; i < itemDisplays.length; ++i) {
            float itemX;
            BottlingMachineBlockEntity.MultiblockProcessBottling process = (BottlingMachineBlockEntity.MultiblockProcessBottling)te.processQueue.get(i);
            if (process == null) continue;
            float processMaxTicks = process.getMaxTicks(te.m_58904_());
            float transportTime = BottlingMachineBlockEntity.getTransportTime(processMaxTicks);
            float liftTime = BottlingMachineBlockEntity.getLiftTime(processMaxTicks);
            float fProcess = process.processTick;
            float itemY = 0.0f;
            float itemFill = 0.0f;
            if (fProcess < transportTime) {
                itemX = 0.5f * fProcess / transportTime;
            } else if (fProcess < processMaxTicks - transportTime) {
                itemX = 0.5f;
                if (fProcess < transportTime + liftTime) {
                    lift = (fProcess - transportTime) / liftTime;
                } else if (fProcess < processMaxTicks - (transportTime + liftTime)) {
                    lift = 1.0f;
                    itemFill = (fProcess - (transportTime + liftTime)) / (processMaxTicks - 2.0f * (transportTime + liftTime));
                } else {
                    lift = 1.0f - (fProcess - (processMaxTicks - transportTime - liftTime)) / liftTime;
                    itemFill = 1.0f;
                }
                lift *= 0.125f;
                if (lift > 0.0625f) {
                    itemY += lift - 0.0625f;
                }
            } else {
                itemX = 0.5f + 0.5f * (fProcess - (processMaxTicks - transportTime)) / transportTime;
                itemFill = 1.0f;
            }
            itemDisplays[i] = new float[]{fProcess, (itemX - 0.5f) * 2.5f, itemY - 0.15625f, 1.0f, itemFill};
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, (double)lift, 0.0);
        BottlingMachineRenderer.renderModelPart(matrixStack, solidBuilder, facing, combinedLightIn, combinedOverlayIn, "lift");
        matrixStack.m_85837_(0.0, (double)(-lift), 0.0);
        matrixStack.m_85849_();
        float dir = facing == Direction.SOUTH ? 180.0f : (facing == Direction.NORTH ? 0.0f : (facing == Direction.EAST ? -90.0f : 90.0f));
        matrixStack.m_85845_(new Quaternion(0.0f, dir, 0.0f, true));
        float scale = 0.0625f;
        FluidStack fs = te.tanks[0].getFluid();
        if (!fs.isEmpty()) {
            float tankWidth = 7.0f;
            matrixStack.m_85836_();
            float level = (float)fs.getAmount() / (float)te.tanks[0].getCapacity();
            matrixStack.m_85837_(-0.21875, 0.376, 1.21875);
            matrixStack.m_85841_(scale, scale, scale);
            matrixStack.m_85837_(3.5, 0.0, -3.5);
            float h = level * 9.0f;
            VertexConsumer builder = originalBuffer.m_6299_(RenderType.m_110466_());
            for (int i = 0; i < 4; ++i) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.0, 0.0, -3.5);
                GuiHelper.drawRepeatedFluidSprite(builder, matrixStack, fs, -3.5f, 0.0f, 7.0f, h);
                matrixStack.m_85849_();
                matrixStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 90.0f, true));
            }
            matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -90.0f, true));
            GuiHelper.drawRepeatedFluidSprite(builder, matrixStack, fs, -3.5f, -3.5f, 7.0f, 7.0f);
            matrixStack.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), 180.0f, true));
            matrixStack.m_85837_(0.0, 0.0, (double)(-h));
            GuiHelper.drawRepeatedFluidSprite(builder, matrixStack, fs, -3.5f, -3.5f, 7.0f, 7.0f);
            matrixStack.m_85849_();
        }
        for (int i = 0; i < itemDisplays.length; ++i) {
            BottlingMachineBlockEntity.MultiblockProcessBottling process;
            if (itemDisplays[i] == null || (process = (BottlingMachineBlockEntity.MultiblockProcessBottling)te.processQueue.get(i)) == null) continue;
            List<ItemStack> display = process.getDisplayItem(te.m_58904_());
            scale = 0.4375f;
            matrixStack.m_85837_((double)itemDisplays[i][1], (double)itemDisplays[i][2], (double)itemDisplays[i][3]);
            matrixStack.m_85841_(scale, scale, scale);
            if (!ClientUtils.mc().m_91385_().isStencilEnabled()) {
                for (ItemStack displayS : display) {
                    ClientUtils.mc().m_91291_().m_174269_(displayS, ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, 0);
                }
            } else {
                float h0 = -0.5f;
                float h1 = h0 + itemDisplays[i][4];
                for (ItemStack inputS : process.inputItems) {
                    this.renderItemPart(bufferIn, matrixStack, inputS, h0, h1, combinedLightIn, combinedOverlayIn, 0);
                }
                for (ItemStack displayS : display) {
                    this.renderItemPart(bufferIn, matrixStack, displayS, h0, h1, combinedLightIn, combinedOverlayIn, 1);
                }
            }
            matrixStack.m_85841_(1.0f / scale, 1.0f / scale, 1.0f / scale);
            matrixStack.m_85837_((double)(-itemDisplays[i][1]), (double)(-itemDisplays[i][2]), (double)(-itemDisplays[i][3]));
        }
        matrixStack.m_85849_();
    }

    public static void renderModelPart(PoseStack matrixStack, VertexConsumer builder, Direction facing, int combinedLightIn, int combinedOverlayIn, String ... parts) {
        SinglePropertyModelData<IEProperties.VisibilityList> data = new SinglePropertyModelData<IEProperties.VisibilityList>(IEProperties.VisibilityList.show(parts), DynamicSubmodelCallbacks.getProperty());
        matrixStack.m_85836_();
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        List<BakedQuad> quads = DYNAMIC.getNullQuads(data);
        BottlingMachineRenderer.rotateForFacing(matrixStack, facing);
        RenderUtils.renderModelTESRFast(quads, builder, matrixStack, combinedLightIn, combinedOverlayIn);
        matrixStack.m_85849_();
    }

    private void renderItemPart(MultiBufferSource baseBuffer, PoseStack matrix, ItemStack item, float minY, float maxY, int combinedLightIn, int combinedOverlayIn, int ref) {
        PoseStack innerStack = new PoseStack();
        innerStack.m_85850_().m_85861_().m_27644_(matrix.m_85850_().m_85861_());
        innerStack.m_85850_().m_85864_().m_8178_(matrix.m_85850_().m_85864_());
        MultiBufferSource stencilWrapper = IERenderTypes.wrapWithStencil(baseBuffer, vertexBuilder -> {
            innerStack.m_85836_();
            innerStack.m_85845_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), 90.0f - ClientUtils.mc().m_91290_().f_114358_.m_90590_(), true));
            RenderUtils.renderBox(vertexBuilder, innerStack, -0.5f, minY, -0.5f, 0.5f, maxY, 0.5f);
            innerStack.m_85849_();
        }, "min" + minY + "max" + maxY, ref);
        BatchingRenderTypeBuffer batchBuffer = new BatchingRenderTypeBuffer();
        ClientUtils.mc().m_91291_().m_174269_(item, ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrix, (MultiBufferSource)batchBuffer, 0);
        batchBuffer.pipe(stencilWrapper);
    }
}

