/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting.builders;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class MineralMixBuilder
extends IEFinishedRecipe<MineralMixBuilder> {
    JsonArray oresArray = new JsonArray();
    JsonArray spoilsArray = new JsonArray();
    JsonArray dimensionsArray = new JsonArray();

    private MineralMixBuilder() {
        super((IERecipeSerializer)((Object)MineralMix.SERIALIZER.get()));
        this.addWriter(jsonObject -> jsonObject.add("ores", (JsonElement)this.oresArray));
        this.addWriter(jsonObject -> jsonObject.add("spoils", (JsonElement)this.spoilsArray));
        this.addWriter(jsonObject -> jsonObject.add("dimensions", (JsonElement)this.dimensionsArray));
    }

    public static MineralMixBuilder builder(ResourceKey<DimensionType> dimension) {
        return new MineralMixBuilder().addDimension(dimension);
    }

    public static MineralMixBuilder builder(ResourceLocation dimension) {
        return new MineralMixBuilder().addDimension(dimension);
    }

    public MineralMixBuilder setWeight(int weight) {
        return (MineralMixBuilder)this.addWriter(jsonObject -> jsonObject.addProperty("weight", (Number)weight));
    }

    public MineralMixBuilder setFailchance(float failChance) {
        return (MineralMixBuilder)this.addWriter(jsonObject -> jsonObject.addProperty("fail_chance", (Number)Float.valueOf(failChance)));
    }

    public MineralMixBuilder setBackground(ResourceLocation resourceLocation) {
        return (MineralMixBuilder)this.addWriter(jsonObject -> jsonObject.addProperty("sample_background", resourceLocation.toString()));
    }

    public MineralMixBuilder addDimension(ResourceKey<DimensionType> dimension) {
        return this.addDimension(dimension.m_135782_());
    }

    public MineralMixBuilder addDimension(ResourceLocation dimension) {
        this.dimensionsArray.add((JsonElement)new JsonPrimitive(dimension.toString()));
        return this;
    }

    public MineralMixBuilder addOre(ItemLike itemProvider, float chance) {
        return this.addOre(new ItemStack(itemProvider), chance);
    }

    public MineralMixBuilder addOre(ItemStack itemStack, float chance) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("chance", (Number)Float.valueOf(chance));
        jsonObject.add("output", (JsonElement)this.serializeItemStack(itemStack));
        this.oresArray.add((JsonElement)jsonObject);
        return this;
    }

    public MineralMixBuilder addOre(TagKey<Item> tag, float chance) {
        return this.addOre(new IngredientWithSize(tag), chance, null);
    }

    public MineralMixBuilder addOre(TagKey<Item> tag, float chance, ICondition condition) {
        return this.addOre(new IngredientWithSize(tag), chance, condition);
    }

    public MineralMixBuilder addOre(IngredientWithSize ingredient, float chance, ICondition condition) {
        JsonObject jsonObject = new JsonObject();
        if (condition != null) {
            JsonArray array = new JsonArray();
            array.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
            jsonObject.add("conditions", (JsonElement)array);
        }
        jsonObject.addProperty("chance", (Number)Float.valueOf(chance));
        jsonObject.add("output", ingredient.serialize());
        this.oresArray.add((JsonElement)jsonObject);
        return this;
    }

    public MineralMixBuilder addOverworldSpoils() {
        JsonObject gravel = new JsonObject();
        gravel.addProperty("chance", (Number)Float.valueOf(0.2f));
        gravel.add("output", (JsonElement)this.serializeItemStack(new ItemStack((ItemLike)Items.f_41832_)));
        this.spoilsArray.add((JsonElement)gravel);
        JsonObject cobblestone = new JsonObject();
        cobblestone.addProperty("chance", (Number)Float.valueOf(0.5f));
        cobblestone.add("output", (JsonElement)this.serializeItemStack(new ItemStack((ItemLike)Items.f_42594_)));
        this.spoilsArray.add((JsonElement)cobblestone);
        JsonObject deepslateCobblestone = new JsonObject();
        deepslateCobblestone.addProperty("chance", (Number)Float.valueOf(0.3f));
        deepslateCobblestone.add("output", (JsonElement)this.serializeItemStack(new ItemStack((ItemLike)Items.f_151035_)));
        this.spoilsArray.add((JsonElement)deepslateCobblestone);
        return this;
    }

    public MineralMixBuilder addSiltSpoils() {
        JsonObject coarseDirt = new JsonObject();
        coarseDirt.addProperty("chance", (Number)Float.valueOf(0.2f));
        coarseDirt.add("output", (JsonElement)this.serializeItemStack(new ItemStack((ItemLike)Items.f_42382_)));
        this.spoilsArray.add((JsonElement)coarseDirt);
        JsonObject cobblestone = new JsonObject();
        cobblestone.addProperty("chance", (Number)Float.valueOf(0.5f));
        cobblestone.add("output", (JsonElement)this.serializeItemStack(new ItemStack((ItemLike)Items.f_42594_)));
        this.spoilsArray.add((JsonElement)cobblestone);
        JsonObject deepslateCobblestone = new JsonObject();
        deepslateCobblestone.addProperty("chance", (Number)Float.valueOf(0.3f));
        deepslateCobblestone.add("output", (JsonElement)this.serializeItemStack(new ItemStack((ItemLike)Items.f_151035_)));
        this.spoilsArray.add((JsonElement)deepslateCobblestone);
        return this;
    }

    public MineralMixBuilder addNetherSpoils() {
        JsonObject netherrack = new JsonObject();
        netherrack.addProperty("chance", (Number)Float.valueOf(0.5f));
        netherrack.add("output", (JsonElement)this.serializeItemStack(new ItemStack((ItemLike)Items.f_42048_)));
        this.spoilsArray.add((JsonElement)netherrack);
        JsonObject basalt = new JsonObject();
        basalt.addProperty("chance", (Number)Float.valueOf(0.3f));
        basalt.add("output", (JsonElement)this.serializeItemStack(new ItemStack((ItemLike)Blocks.f_50137_.m_5456_())));
        this.spoilsArray.add((JsonElement)basalt);
        JsonObject gravel = new JsonObject();
        gravel.addProperty("chance", (Number)Float.valueOf(0.2f));
        gravel.add("output", (JsonElement)this.serializeItemStack(new ItemStack((ItemLike)Blocks.f_49994_.m_5456_())));
        this.spoilsArray.add((JsonElement)gravel);
        return this;
    }
}

