/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class IEApi {
    public static List<? extends String> modPreference;
    private static HashMap<TagKey<Item>, ItemStack> oreOutputPreference;
    public static int revolverTextureSheetID;
    public static HashMap<String, Integer[]> prefixToIngotMap;
    public static List<Supplier<MobEffect>> potions;
    public static List<Runnable> renderCacheClearers;
    @Deprecated(forRemoval=true)
    public static final List<Predicate<ItemStack>> forbiddenInCrates;

    public static ItemStack getPreferredTagStack(RegistryAccess tags, TagKey<Item> tag) {
        return oreOutputPreference.computeIfAbsent(tag, rl -> IEApi.getPreferredElementbyMod(TagUtils.elementStream(tags, rl)).orElse(Items.f_41852_).m_7968_()).m_41777_();
    }

    public static <T extends IForgeRegistryEntry<T>> Optional<T> getPreferredElementbyMod(Stream<T> list) {
        return IEApi.getPreferredElementbyMod(list, IForgeRegistryEntry::getRegistryName);
    }

    public static <T> Optional<T> getPreferredElementbyMod(Stream<T> list, Function<T, ResourceLocation> getName) {
        return list.min(Comparator.comparingInt(t -> {
            ResourceLocation name = (ResourceLocation)getName.apply(t);
            String modId = name.m_135827_();
            int idx = modPreference.indexOf(modId);
            if (idx < 0) {
                return modPreference.size();
            }
            return idx;
        }).thenComparing(getName));
    }

    public static ItemStack getPreferredStackbyMod(ItemStack[] array) {
        return IEApi.getPreferredElementbyMod(Arrays.stream(array), stack -> stack.m_41720_().getRegistryName()).orElseThrow(() -> new RuntimeException("Empty array?"));
    }

    public static boolean isAllowedInCrate(ItemStack stack) {
        if (!stack.m_41720_().m_142095_() || stack.m_204117_(IETags.forbiddenInCrates)) {
            return false;
        }
        for (Predicate<ItemStack> check : forbiddenInCrates) {
            if (!check.test(stack)) continue;
            return false;
        }
        return true;
    }

    public static String getCurrentVersion() {
        return ModList.get().getModFileById("immersiveengineering").versionString();
    }

    static {
        oreOutputPreference = new HashMap();
        prefixToIngotMap = new HashMap();
        renderCacheClearers = new ArrayList<Runnable>();
        forbiddenInCrates = new ArrayList<Predicate<ItemStack>>();
    }
}

