/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.platform.forge.client.model;

import agency.highlysuspect.packages.block.PBlocks;
import agency.highlysuspect.packages.block.PackageBlock;
import agency.highlysuspect.packages.client.PackageModelBakery;
import agency.highlysuspect.packages.client.PackagesClient;
import agency.highlysuspect.packages.junk.PUtil;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.Nullable;

public class BakedQuadPackageModelBakery
implements PackageModelBakery<List<BakedQuad>> {
    public final BakedModel baseModel;
    public final TextureAtlasSprite specialFrameSprite;
    public final TextureAtlasSprite specialInnerSprite;
    private static final int vertexStride = DefaultVertexFormat.f_85811_.m_86017_();
    private static final int vertexColorOffset = 3;
    private static final int vertexUOffset = 4;
    private static final int vertexVOffset = 5;

    public BakedQuadPackageModelBakery(BakedModel baseModel, TextureAtlasSprite specialFrameSprite, TextureAtlasSprite specialInnerSprite) {
        this.baseModel = baseModel;
        this.specialFrameSprite = specialFrameSprite;
        this.specialInnerSprite = specialInnerSprite;
    }

    @Override
    public BakedModel getBaseModel() {
        return this.baseModel;
    }

    @Override
    public List<BakedQuad> bake(@Nullable Object cacheKey, @Nullable DyeColor faceColor, @Nullable Block frameBlock, @Nullable Block innerBlock) {
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>();
        BlockRenderDispatcher mgr = Minecraft.m_91087_().m_91289_();
        @Nullable BlockState frameState = frameBlock == null ? null : frameBlock.m_49966_();
        @Nullable TextureAtlasSprite frameSprite = frameState == null ? null : mgr.m_110910_(frameState).getParticleIcon((IModelData)EmptyModelData.INSTANCE);
        @Nullable BlockState innerState = innerBlock == null ? null : innerBlock.m_49966_();
        @Nullable TextureAtlasSprite innerSprite = innerState == null ? null : mgr.m_110910_(innerState).getParticleIcon((IModelData)EmptyModelData.INSTANCE);
        Random random = new Random(42L);
        for (Direction cullFace : PUtil.DIRECTIONS_AND_NULL) {
            for (BakedQuad quad : this.baseModel.getQuads(((PackageBlock)((Object)PBlocks.PACKAGE.get())).m_49966_(), cullFace, random, (IModelData)EmptyModelData.INSTANCE)) {
                BakedQuad copy;
                if (quad.m_111305_() == 1) {
                    if (faceColor == null) continue;
                    int tint = 0xFF000000 | faceColor.m_41069_().f_76396_;
                    if (PackagesClient.instance.config.swapRedAndBlue) {
                        tint = BakedQuadPackageModelBakery.swapRedAndBlue(tint);
                    }
                    copy = BakedQuadPackageModelBakery.copyQuad(quad);
                    BakedQuadPackageModelBakery.setTintColor(copy, tint, tint, tint, tint);
                    result.add(copy);
                    continue;
                }
                QuadUvBounds bounds = QuadUvBounds.readOff(quad);
                if (bounds.displaysSprite(this.specialFrameSprite)) {
                    if (frameSprite == null) continue;
                    copy = BakedQuadPackageModelBakery.copyQuad(quad);
                    bounds.remapQuad(copy, this.specialFrameSprite, frameSprite);
                    result.add(copy);
                    continue;
                }
                if (bounds.displaysSprite(this.specialInnerSprite)) {
                    if (innerSprite == null) continue;
                    copy = BakedQuadPackageModelBakery.copyQuad(quad);
                    bounds.remapQuad(copy, this.specialInnerSprite, innerSprite);
                    result.add(copy);
                    continue;
                }
                result.add(quad);
            }
        }
        return result;
    }

    private static BakedQuad copyQuad(BakedQuad in) {
        int[] vertsCopy = new int[in.m_111303_().length];
        System.arraycopy(in.m_111303_(), 0, vertsCopy, 0, vertsCopy.length);
        return new BakedQuad(vertsCopy, in.m_111305_(), in.m_111306_(), in.m_173410_(), in.m_111307_());
    }

    private static void setTintColor(BakedQuad in, int color1, int color2, int color3, int color4) {
        in.m_111303_()[BakedQuadPackageModelBakery.vertexColorOffset] = color1;
        in.m_111303_()[BakedQuadPackageModelBakery.vertexStride + BakedQuadPackageModelBakery.vertexColorOffset] = color2;
        in.m_111303_()[2 * BakedQuadPackageModelBakery.vertexStride + BakedQuadPackageModelBakery.vertexColorOffset] = color3;
        in.m_111303_()[3 * BakedQuadPackageModelBakery.vertexStride + BakedQuadPackageModelBakery.vertexColorOffset] = color4;
    }

    private static int swapRedAndBlue(int color) {
        return (color & 0xFF0000) >> 16 | (color & 0xFF) << 16 | color & 0xFF00FF00;
    }

    private static float getU(BakedQuad in, int vertex) {
        return Float.intBitsToFloat(in.m_111303_()[vertex * vertexStride + vertexUOffset]);
    }

    private static void setU(BakedQuad in, int vertex, float u) {
        in.m_111303_()[vertex * BakedQuadPackageModelBakery.vertexStride + BakedQuadPackageModelBakery.vertexUOffset] = Float.floatToRawIntBits(u);
    }

    private static float getV(BakedQuad in, int vertex) {
        return Float.intBitsToFloat(in.m_111303_()[vertex * vertexStride + vertexVOffset]);
    }

    private static void setV(BakedQuad in, int vertex, float v) {
        in.m_111303_()[vertex * BakedQuadPackageModelBakery.vertexStride + BakedQuadPackageModelBakery.vertexVOffset] = Float.floatToRawIntBits(v);
    }

    record QuadUvBounds(float minU, float maxU, float minV, float maxV) {
        static QuadUvBounds readOff(BakedQuad in) {
            float minU = Float.POSITIVE_INFINITY;
            float maxU = Float.NEGATIVE_INFINITY;
            float minV = Float.POSITIVE_INFINITY;
            float maxV = Float.NEGATIVE_INFINITY;
            for (int i = 0; i < 4; ++i) {
                float v;
                float u = BakedQuadPackageModelBakery.getU(in, i);
                if (minU > u) {
                    minU = u;
                }
                if (maxU < u) {
                    maxU = u;
                }
                if (minV > (v = BakedQuadPackageModelBakery.getV(in, i))) {
                    minV = v;
                }
                if (!(maxV < v)) continue;
                maxV = v;
            }
            return new QuadUvBounds(minU, maxU, minV, maxV);
        }

        boolean displaysSprite(TextureAtlasSprite sprite) {
            return sprite.m_118409_() <= this.minU && sprite.m_118410_() >= this.maxU && sprite.m_118411_() <= this.minV && sprite.m_118412_() >= this.maxV;
        }

        void remapQuad(BakedQuad in, TextureAtlasSprite specialSprite, TextureAtlasSprite newSprite) {
            float remappedMinU = PUtil.rangeRemap(this.minU, specialSprite.m_118409_(), specialSprite.m_118410_(), newSprite.m_118409_(), newSprite.m_118410_());
            float remappedMaxU = PUtil.rangeRemap(this.maxU, specialSprite.m_118409_(), specialSprite.m_118410_(), newSprite.m_118409_(), newSprite.m_118410_());
            float remappedMinV = PUtil.rangeRemap(this.minV, specialSprite.m_118411_(), specialSprite.m_118412_(), newSprite.m_118411_(), newSprite.m_118412_());
            float remappedMaxV = PUtil.rangeRemap(this.maxV, specialSprite.m_118411_(), specialSprite.m_118412_(), newSprite.m_118411_(), newSprite.m_118412_());
            for (int i = 0; i < 4; ++i) {
                BakedQuadPackageModelBakery.setU(in, i, Mth.m_14033_((float)BakedQuadPackageModelBakery.getU(in, i), (float)this.minU) ? remappedMinU : remappedMaxU);
                BakedQuadPackageModelBakery.setV(in, i, Mth.m_14033_((float)BakedQuadPackageModelBakery.getV(in, i), (float)this.minV) ? remappedMinV : remappedMaxV);
            }
        }
    }
}

