/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.platform.forge.client;

import agency.highlysuspect.packages.client.PackageActionBinding;
import agency.highlysuspect.packages.client.PackagesClient;
import agency.highlysuspect.packages.client.PackagesClientConfig;
import agency.highlysuspect.packages.net.PackageAction;
import agency.highlysuspect.packages.platform.ClientPlatformConfig;
import agency.highlysuspect.packages.platform.forge.AbstractForgePlatformConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ForgeClientPlatformConfig
extends AbstractForgePlatformConfig
implements ClientPlatformConfig {
    private ForgeConfigSpec.ConfigValue<String> insertOneBindingUnparsed;
    private ForgeConfigSpec.ConfigValue<String> insertStackBindingUnparsed;
    private ForgeConfigSpec.ConfigValue<String> insertAllBindingUnparsed;
    private ForgeConfigSpec.ConfigValue<String> takeOneBindingUnparsed;
    private ForgeConfigSpec.ConfigValue<String> takeStackBindingUnparsed;
    private ForgeConfigSpec.ConfigValue<String> takeAllBindingUnparsed;
    private ForgeConfigSpec.ConfigValue<Integer> punchRepeat;
    private ForgeConfigSpec.ConfigValue<Boolean> swapRedAndBlue;
    private ForgeConfigSpec.ConfigValue<Boolean> cacheMeshes;

    @Override
    protected void configure(ForgeConfigSpec.Builder bob) {
        bob.comment(new String[]{"Specify at least 'use' (right click) or 'punch' (left click), and optionally add", "any combination of 'ctrl', 'alt', or 'sneak' to require some modifier keys.", "Separate multiple items with hyphens. Disable an action entirely by leaving it blank."}).push("Keys");
        this.insertOneBindingUnparsed = bob.comment("How do you insert one item into the package?").define("insertOne", (Object)"use");
        this.insertStackBindingUnparsed = bob.comment("How do you insert one stack of items into the package?").define("insertStack", (Object)"sneak-use");
        this.insertAllBindingUnparsed = bob.comment("How do you insert everything in your inventory that fits into the package?").define("insertAll", (Object)"ctrl-use");
        this.takeOneBindingUnparsed = bob.comment("How do you take one item from the package?").define("takeOne", (Object)"punch");
        this.takeStackBindingUnparsed = bob.comment("How do you take one stack of items from the package?").define("takeStack", (Object)"sneak-punch");
        this.takeAllBindingUnparsed = bob.comment("How do you clear all items from the package?").define("takeAll", (Object)"ctrl-punch");
        this.punchRepeat = bob.comment(new String[]{"Older versions of Packages had a \"feature\" where holding left-click would slowly trickle items out of the Package.", "This was actually a bug, caused by code intended to differentiatiate between 'starting a left click' and 'continuing", "a left click' not working correctly; the delay was my band-aid fix.", "I've since actually fixed it, but I don't know if people had gotten used to the broken behavior :)", "If you did and want it back, set this to 4."}).define("punchRepeat", (Object)-1);
        bob.pop();
        bob.push("Model");
        this.cacheMeshes = bob.comment(new String[]{"If 'true', Package and Package Crafter 3d models will be cached in-memory, instead of rebaked from scratch every time.", "The model bakery is quite fast; this probably helps chunk-bake performance less than it sounds like it would, and consumes memory.", "However I'm pretty sure it slightly improves the efficiency of item rendering. All's tradeoffs.", "F3+T will dump the cache."}).define("cacheMeshes", true);
        this.swapRedAndBlue = bob.comment(new String[]{"For some reason I need this on Forge only, to make the front face of Packages render with the correct color.", "If you need to reset this to 'false', I'd be interested in hearing what mods you're using."}).define("swapRedAndBlue", true);
        bob.pop();
    }

    @Override
    protected void install() {
        PackagesClient.instance.config = PackagesClientConfig.makeConfig(this);
    }

    @Override
    public void registerAndLoadAndAllThatJazz() {
        this.setup(ModConfig.Type.CLIENT);
    }

    @Override
    public PackageActionBinding insertOneBinding() {
        return PackageActionBinding.fromString(PackageAction.INSERT_ONE, (String)this.insertOneBindingUnparsed.get());
    }

    @Override
    public PackageActionBinding insertStackBinding() {
        return PackageActionBinding.fromString(PackageAction.INSERT_STACK, (String)this.insertStackBindingUnparsed.get());
    }

    @Override
    public PackageActionBinding insertAllBinding() {
        return PackageActionBinding.fromString(PackageAction.INSERT_ALL, (String)this.insertAllBindingUnparsed.get());
    }

    @Override
    public PackageActionBinding takeOneBinding() {
        return PackageActionBinding.fromString(PackageAction.TAKE_ONE, (String)this.takeOneBindingUnparsed.get());
    }

    @Override
    public PackageActionBinding takeStackBinding() {
        return PackageActionBinding.fromString(PackageAction.TAKE_STACK, (String)this.takeStackBindingUnparsed.get());
    }

    @Override
    public PackageActionBinding takeAllBinding() {
        return PackageActionBinding.fromString(PackageAction.TAKE_ALL, (String)this.takeAllBindingUnparsed.get());
    }

    @Override
    public int punchRepeat() {
        return (Integer)this.punchRepeat.get();
    }

    @Override
    public boolean cacheMeshes() {
        return (Boolean)this.cacheMeshes.get();
    }

    @Override
    public boolean swapRedAndBlue() {
        return (Boolean)this.swapRedAndBlue.get();
    }

    @Override
    public boolean frexSupport() {
        return false;
    }
}

