/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.platform.forge;

import agency.highlysuspect.packages.Packages;
import agency.highlysuspect.packages.PackagesConfig;
import agency.highlysuspect.packages.platform.CommonPlatformConfig;
import agency.highlysuspect.packages.platform.forge.AbstractForgePlatformConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ForgeCommonPlatformConfig
extends AbstractForgePlatformConfig
implements CommonPlatformConfig {
    private ForgeConfigSpec.ConfigValue<Boolean> inventoryInteractions;
    private ForgeConfigSpec.ConfigValue<Boolean> interactionSounds;
    private ForgeConfigSpec.ConfigValue<Boolean> packageMakerAllowlistMode;

    @Override
    protected void configure(ForgeConfigSpec.Builder bob) {
        bob.push("Features");
        this.inventoryInteractions = bob.comment("Allow interacting with Packages in the player inventory, kinda like a Bundle.").define("inventoryInteractions", true);
        this.interactionSounds = bob.comment("Play sounds when players interact with a Package.").define("interactionSounds", true);
        this.packageMakerAllowlistMode = bob.comment(new String[]{"If 'true', the item tags `packages:allowlist_package_maker_frame` and `packages:allowlist_package_maker_inner`", "will be read, and only the items specified in those tags will be allowed to enter the Frame and Core slots of", "the Package Maker. This is mainly for modpackers to mess with; you should also probably add something to the tooltip", "lang keys (`packages.package_maker.frame.X`, where X is a one-indexed line number) to describe the behavior you create."}).define("packageMakerAllowlistMode", false);
        bob.pop();
    }

    @Override
    protected void install() {
        Packages.instance.config = PackagesConfig.makeConfig(this);
    }

    @Override
    public void registerAndLoadAndAllThatJazz() {
        this.setup(ModConfig.Type.COMMON);
    }

    @Override
    public boolean inventoryInteractions() {
        return (Boolean)this.inventoryInteractions.get();
    }

    @Override
    public boolean interactionSounds() {
        return (Boolean)this.interactionSounds.get();
    }

    @Override
    public boolean packageMakerAllowlistMode() {
        return (Boolean)this.packageMakerAllowlistMode.get();
    }
}

