/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.junk;

import agency.highlysuspect.packages.item.PItems;
import agency.highlysuspect.packages.junk.PTags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.jetbrains.annotations.Nullable;

public class PackageContainer
implements Container {
    public static final int SLOT_COUNT = 8;
    public static final int RECURSION_LIMIT = 3;
    public static final String KEY = "PackageContents";
    private final NonNullList<ItemStack> inv = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    private final List<ContainerListener> listeners = new ArrayList<ContainerListener>();

    public PackageContainer addListener(ContainerListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public void removeListener(ContainerListener listener) {
        this.listeners.remove(listener);
    }

    public ItemStack getFilterStack() {
        for (ItemStack stack : this.inv) {
            if (stack.m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public int getCount() {
        int count = 0;
        for (ItemStack stack : this.inv) {
            count += stack.m_41613_();
        }
        return count;
    }

    public ItemStack computeRootContents() {
        PackageContainer subcontents = PackageContainer.fromItemStack(this.getFilterStack());
        return subcontents == null ? this.getFilterStack() : subcontents.computeRootContents();
    }

    public int computeFullyMultipliedCount() {
        PackageContainer subcontents = PackageContainer.fromItemStack(this.getFilterStack());
        return (subcontents == null ? 1 : subcontents.computeFullyMultipliedCount()) * this.getCount();
    }

    public boolean computeAmplificationStatus() {
        PackageContainer subcontents = PackageContainer.fromItemStack(this.getFilterStack());
        if (subcontents != null) {
            return this.getCount() > 1 || subcontents.computeAmplificationStatus();
        }
        return false;
    }

    public boolean isFull() {
        return Mth.m_14033_((float)this.fillPercentage(), (float)1.0f);
    }

    public float fillPercentage() {
        int maxCount = this.maxStackAmountAllowed(this.getFilterStack()) * 8;
        if (maxCount == 0) {
            return 1.0f;
        }
        return (float)this.getCount() / (float)maxCount;
    }

    public boolean allowedInPackageAtAll(ItemStack stack) {
        BlockItem bi;
        if (stack.m_204117_(PTags.BANNED_FROM_PACKAGE)) {
            return false;
        }
        boolean checkCanFitInsideContainerItems = true;
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (bi = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock) {
            checkCanFitInsideContainerItems = false;
            CompoundTag blockEntityTag = stack.m_41737_("BlockEntityTag");
            if (blockEntityTag != null && !blockEntityTag.m_128437_("Items", 10).isEmpty()) {
                return false;
            }
        }
        if (stack.m_41720_() instanceof BundleItem) {
            checkCanFitInsideContainerItems = false;
            if (stack.m_150947_()) {
                return false;
            }
        }
        if (checkCanFitInsideContainerItems && !stack.m_41720_().m_142095_()) {
            return false;
        }
        PackageContainer cont = PackageContainer.fromItemStack(stack);
        if (cont == null) {
            return true;
        }
        return cont.calcRecursionLevel() < 3;
    }

    public int maxStackAmountAllowed(ItemStack stack) {
        PackageContainer recur = PackageContainer.fromItemStack(stack);
        if (recur != null && recur.getCount() > 0) {
            return 1;
        }
        return Math.min(stack.m_41741_(), 64);
    }

    private int calcRecursionLevel() {
        PackageContainer recur = PackageContainer.fromItemStack(this.getFilterStack());
        if (recur == null) {
            return 0;
        }
        return 1 + recur.calcRecursionLevel();
    }

    public boolean matches(ItemStack stack) {
        ItemStack filter = this.getFilterStack();
        if (filter.m_41619_() || stack.m_41619_()) {
            return true;
        }
        return ItemStack.m_150942_((ItemStack)filter, (ItemStack)stack);
    }

    public ItemStack insert(ItemStack toInsert, int maxAmountToInsert, boolean simulate) {
        if (toInsert.m_41619_() || !this.matches(toInsert) || !this.allowedInPackageAtAll(toInsert)) {
            return toInsert;
        }
        int remainingAmountToInsert = Math.min(toInsert.m_41613_(), maxAmountToInsert);
        int amountInserted = 0;
        int maxStackAmountPerSlot = this.maxStackAmountAllowed(toInsert);
        for (int slot = 0; slot < 8 && remainingAmountToInsert > 0; ++slot) {
            ItemStack newStack;
            int amountToInsertThisSlot = Math.min(remainingAmountToInsert, maxStackAmountPerSlot);
            ItemStack currentStack = this.m_8020_(slot);
            if (currentStack.m_41619_()) {
                newStack = toInsert.m_41777_();
                newStack.m_41764_(amountToInsertThisSlot);
            } else {
                int remainingSpaceThisSlot = maxStackAmountPerSlot - currentStack.m_41613_();
                if (remainingSpaceThisSlot <= 0) continue;
                amountToInsertThisSlot = Math.min(amountToInsertThisSlot, remainingSpaceThisSlot);
                newStack = simulate ? currentStack.m_41777_() : currentStack;
                newStack.m_41769_(amountToInsertThisSlot);
            }
            remainingAmountToInsert -= amountToInsertThisSlot;
            amountInserted += amountToInsertThisSlot;
            if (simulate) continue;
            this.m_6836_(slot, newStack);
        }
        ItemStack remaining = toInsert.m_41777_();
        remaining.m_41774_(amountInserted);
        return remaining;
    }

    public ItemStack take(int maxAmountToTake, boolean simulate) {
        ItemStack filter = this.getFilterStack();
        if (filter.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int remainingAmountToTake = maxAmountToTake;
        int amountTook = 0;
        for (int slot = 7; slot >= 0 && remainingAmountToTake > 0; --slot) {
            ItemStack newStack;
            ItemStack currentStack = this.m_8020_(slot);
            if (currentStack.m_41619_()) continue;
            int amountToTakeThisSlot = Math.min(remainingAmountToTake, currentStack.m_41613_());
            if (amountToTakeThisSlot == currentStack.m_41613_()) {
                newStack = ItemStack.f_41583_;
            } else {
                newStack = simulate ? currentStack.m_41777_() : currentStack;
                newStack.m_41774_(amountToTakeThisSlot);
            }
            remainingAmountToTake -= amountToTakeThisSlot;
            amountTook += amountToTakeThisSlot;
            if (simulate) continue;
            this.m_6836_(slot, newStack);
        }
        filter = filter.m_41777_();
        filter.m_41764_(amountTook);
        return filter;
    }

    public static List<ItemStack> flattenOverstack(ItemStack mutOverstack) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        while (!mutOverstack.m_41619_()) {
            result.add(mutOverstack.m_41620_(mutOverstack.m_41741_()));
        }
        return result;
    }

    public int m_6643_() {
        return 8;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.inv) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inv.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        this.m_6596_();
        return ContainerHelper.m_18969_(this.inv, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        this.m_6596_();
        return ContainerHelper.m_18966_(this.inv, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inv.set(slot, (Object)stack);
        this.m_6596_();
    }

    public int m_6893_() {
        return this.maxStackAmountAllowed(this.getFilterStack());
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (!this.allowedInPackageAtAll(stack)) {
            return false;
        }
        PackageContainer hereContainer = PackageContainer.fromItemStack(this.m_8020_(slot));
        if (hereContainer != null && !hereContainer.m_7983_()) {
            return false;
        }
        return this.matches(stack);
    }

    public void m_6596_() {
        for (ContainerListener l : this.listeners) {
            l.m_5757_((Container)this);
        }
    }

    public void m_6211_() {
        this.inv.clear();
        this.m_6596_();
    }

    public CompoundTag toTag() {
        return this.toTag(new CompoundTag());
    }

    public CompoundTag toTag(CompoundTag writeTo) {
        ItemStack first = this.getFilterStack();
        if (!first.m_41619_()) {
            CompoundTag stackTag = this.getFilterStack().m_41739_(new CompoundTag());
            stackTag.m_128344_("Count", (byte)1);
            writeTo.m_128365_("stack", (Tag)stackTag);
            writeTo.m_128405_("realCount", this.getCount());
        } else {
            writeTo.m_128405_("realCount", 0);
        }
        return writeTo;
    }

    public void readFromTag(CompoundTag tag) {
        this.m_6211_();
        int count = tag.m_128451_("realCount");
        if (count != 0) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("stack"));
            int maxPerSlot = this.maxStackAmountAllowed(stack);
            int remaining = count;
            for (int slot = 0; remaining > 0 && slot < 8; remaining -= maxPerSlot, ++slot) {
                ItemStack toInsert = stack.m_41777_();
                toInsert.m_41764_(Math.min(remaining, maxPerSlot));
                this.m_6836_(slot, toInsert);
            }
        }
    }

    public static PackageContainer fromTag(CompoundTag tag) {
        PackageContainer r = new PackageContainer();
        r.readFromTag(tag);
        return r;
    }

    @Nullable
    public static PackageContainer fromItemStack(ItemStack stack) {
        if (stack.m_41619_() || stack.m_41720_() != PItems.PACKAGE.get()) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        return PackageContainer.fromTag(tag.m_128469_("BlockEntityTag").m_128469_(KEY));
    }

    public static boolean existsOnItemStack(ItemStack stack) {
        if (stack.m_41619_() || stack.m_41720_() != PItems.PACKAGE.get()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        CompoundTag blockEntityTag = tag.m_128469_("BlockEntityTag");
        if (blockEntityTag == null || blockEntityTag.m_128456_()) {
            return false;
        }
        CompoundTag key = blockEntityTag.m_128469_(KEY);
        return key != null && !key.m_128456_();
    }

    public ItemStack writeToStackTag(ItemStack stack) {
        stack.m_41698_("BlockEntityTag").m_128365_(KEY, (Tag)this.toTag());
        return stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T mutateItemStack(ItemStack stack, Function<PackageContainer, T> action, T ifNoContainer) {
        PackageContainer cont = PackageContainer.fromItemStack(stack);
        if (cont == null) {
            return ifNoContainer;
        }
        try {
            T t = action.apply(cont);
            return t;
        }
        finally {
            cont.writeToStackTag(stack);
        }
    }
}

