/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.container;

import agency.highlysuspect.packages.Packages;
import agency.highlysuspect.packages.block.PackageMakerBlockEntity;
import agency.highlysuspect.packages.container.PMenuTypes;
import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class PackageMakerMenu
extends AbstractContainerMenu {
    public final Container container;
    public static final ResourceLocation FRAME_BG = Packages.id("gui/slot_frame");
    public static final ResourceLocation INNER_BG = Packages.id("gui/slot_inner");
    public static final ResourceLocation DYE_BG = Packages.id("gui/slot_dye");
    public static final ResourceLocation EXTRA_BG = Packages.id("gui/slot_extra");

    public PackageMakerMenu(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(5));
    }

    public PackageMakerMenu(int syncId, Inventory playerInventory, Container container) {
        super((MenuType)PMenuTypes.PACKAGE_MAKER.get(), syncId);
        this.container = container;
        this.m_38897_(new FunkySlot(container, 0, 16, 25, FRAME_BG, PackageMakerBlockEntity::matchesFrameSlot));
        this.m_38897_(new FunkySlot(container, 1, 36, 25, INNER_BG, PackageMakerBlockEntity::matchesInnerSlot));
        this.m_38897_(new FunkySlot(container, 2, 16, 45, DYE_BG, PackageMakerBlockEntity::matchesDyeSlot));
        this.m_38897_(new FunkySlot(container, 3, 36, 45, EXTRA_BG, PackageMakerBlockEntity::matchesExtraSlot));
        this.m_38897_(new FunkySlot(container, 4, 134, 35, null, stack -> false));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    public boolean m_6366_(Player player, int id) {
        Container container;
        if ((id == 0 || id == 1) && (container = this.container) instanceof PackageMakerBlockEntity) {
            PackageMakerBlockEntity be = (PackageMakerBlockEntity)container;
            be.performCraft(id == 1 ? 64 : 1);
            return true;
        }
        return false;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int invSlot) {
        ItemStack what = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(invSlot);
        if (slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            what = itemStack2.m_41777_();
            if (invSlot < 5 ? !this.m_38903_(itemStack2, 5, 41, true) : !this.m_38903_(itemStack2, 0, 5, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack2.m_41613_() == what.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
        }
        return what;
    }

    public static class FunkySlot
    extends Slot {
        private final ResourceLocation background;
        private final Predicate<ItemStack> mayPlace;

        public FunkySlot(Container inventory, int slot, int x, int y, @Nullable ResourceLocation background, Predicate<ItemStack> mayPlace) {
            super(inventory, slot, x, y);
            this.background = background;
            this.mayPlace = mayPlace;
        }

        public boolean m_5857_(ItemStack stack) {
            return this.mayPlace.test(stack);
        }

        @Nullable
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            if (this.background == null) {
                return null;
            }
            return Pair.of((Object)InventoryMenu.f_39692_, (Object)this.background);
        }
    }
}

